/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.core.ResolvableType;
import org.springframework.data.projection.MethodInterceptorFactory;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.web.JsonProjectingMethodInterceptorFactory;
import org.springframework.kafka.support.KafkaNull;
import org.springframework.kafka.support.converter.ConversionException;
import org.springframework.kafka.support.converter.MessagingMessageConverter;
import org.springframework.kafka.support.converter.StringJsonMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class ProjectingMessageConverter
extends MessagingMessageConverter {
    private final ProjectionFactory projectionFactory;
    private final MessagingMessageConverter delegate;

    public ProjectingMessageConverter(ObjectMapper mapper) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null");
        JacksonMappingProvider provider = new JacksonMappingProvider(mapper);
        JsonProjectingMethodInterceptorFactory interceptorFactory = new JsonProjectingMethodInterceptorFactory((MappingProvider)provider);
        SpelAwareProxyProjectionFactory factory = new SpelAwareProxyProjectionFactory();
        factory.registerMethodInvokerFactory((MethodInterceptorFactory)interceptorFactory);
        this.projectionFactory = factory;
        this.delegate = new StringJsonMessageConverter(mapper);
    }

    @Override
    protected Object convertPayload(Message<?> message) {
        return this.delegate.convertPayload(message);
    }

    @Override
    protected Object extractAndConvertValue(ConsumerRecord<?, ?> record, Type type) {
        Object value = record.value();
        if (value == null) {
            return KafkaNull.INSTANCE;
        }
        Class rawType = ResolvableType.forType((Type)type).resolve(Object.class);
        if (!rawType.isInterface()) {
            return this.delegate.extractAndConvertValue(record, type);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(ProjectingMessageConverter.getAsByteArray(value));
        return this.projectionFactory.createProjection(rawType, (Object)inputStream);
    }

    private static byte[] getAsByteArray(Object source) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        if (source instanceof String) {
            return ((String)String.class.cast(source)).getBytes(StandardCharsets.UTF_8);
        }
        if (source instanceof byte[]) {
            return (byte[])byte[].class.cast(source);
        }
        throw new ConversionException(String.format("Unsupported payload type '%s'. Expected 'String' or 'byte[]'", source.getClass()), null);
    }
}

