/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.common.header.Header;
import org.springframework.kafka.support.KafkaHeaderMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;

public abstract class AbstractKafkaHeaderMapper
implements KafkaHeaderMapper {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final List<SimplePatternBasedHeaderMatcher> NEVER_MAPPED = Arrays.asList(new SimplePatternBasedHeaderMatcher("!kafka_acknowledgment"), new SimplePatternBasedHeaderMatcher("!kafka_consumer"), new SimplePatternBasedHeaderMatcher("!kafka_messageKey"), new SimplePatternBasedHeaderMatcher("!kafka_offset"), new SimplePatternBasedHeaderMatcher("!kafka_partitionId"), new SimplePatternBasedHeaderMatcher("!kafka_data"), new SimplePatternBasedHeaderMatcher("!kafka_receivedMessageKey"), new SimplePatternBasedHeaderMatcher("!kafka_receivedPartitionId"), new SimplePatternBasedHeaderMatcher("!kafka_receivedTimestamp"), new SimplePatternBasedHeaderMatcher("!kafka_receivedTopic"), new SimplePatternBasedHeaderMatcher("!kafka_timestamp"), new SimplePatternBasedHeaderMatcher("!kafka_timestampType"), new SimplePatternBasedHeaderMatcher("!kafka_batchConvertedHeaders"), new SimplePatternBasedHeaderMatcher("!kafka_nativeHeaders"), new SimplePatternBasedHeaderMatcher("!kafka_topic"));
    protected final List<SimplePatternBasedHeaderMatcher> matchers = new ArrayList<SimplePatternBasedHeaderMatcher>(NEVER_MAPPED);
    private final Map<String, Boolean> rawMappedtHeaders = new HashMap<String, Boolean>();
    private boolean mapAllStringsOut;
    private Charset charset = StandardCharsets.UTF_8;

    public AbstractKafkaHeaderMapper(String ... patterns) {
        Assert.notNull((Object)patterns, (String)"'patterns' must not be null");
        for (String pattern : patterns) {
            this.matchers.add(new SimplePatternBasedHeaderMatcher(pattern));
        }
    }

    public void setMapAllStringsOut(boolean mapAllStringsOut) {
        this.mapAllStringsOut = mapAllStringsOut;
    }

    protected Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        Assert.notNull((Object)charset, (String)"'charset' cannot be null");
        this.charset = charset;
    }

    public void setRawMappedHaeaders(Map<String, Boolean> rawMappedHeaders) {
        if (!ObjectUtils.isEmpty(rawMappedHeaders)) {
            this.rawMappedtHeaders.clear();
            this.rawMappedtHeaders.putAll(rawMappedHeaders);
        }
    }

    protected boolean matches(String header, Object value) {
        if (this.matches(header)) {
            if ((header.equals("replyChannel") || header.equals("errorChannel")) && !(value instanceof String)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Cannot map " + header + " when type is [" + value.getClass() + "]; it must be a String"));
                }
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean matches(String header) {
        for (SimplePatternBasedHeaderMatcher matcher : this.matchers) {
            if (!matcher.matchHeader(header)) continue;
            return !matcher.isNegated();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL NOT be mapped; matched no patterns", header));
        }
        return false;
    }

    protected Object headerValueToAddOut(String key, Object value) {
        Object valueToAdd = this.mapRawOut(key, value);
        if (valueToAdd == null) {
            valueToAdd = value;
        }
        return valueToAdd;
    }

    @Nullable
    private byte[] mapRawOut(String header, Object value) {
        if (this.mapAllStringsOut || this.rawMappedtHeaders.containsKey(header)) {
            if (value instanceof byte[]) {
                return (byte[])value;
            }
            if (value instanceof String) {
                return ((String)value).getBytes(this.charset);
            }
        }
        return null;
    }

    protected Object headertValueToAddIn(Header header) {
        Object mapped = this.mapRawIn(header.key(), header.value());
        if (mapped == null) {
            mapped = header.value();
        }
        return mapped;
    }

    @Nullable
    private String mapRawIn(String header, byte[] value) {
        Boolean asString = this.rawMappedtHeaders.get(header);
        if (Boolean.TRUE.equals(asString)) {
            return new String(value, this.charset);
        }
        return null;
    }

    protected static class SimplePatternBasedHeaderMatcher {
        private static final Log logger = LogFactory.getLog(SimplePatternBasedHeaderMatcher.class);
        private final String pattern;
        private final boolean negate;

        public SimplePatternBasedHeaderMatcher(String pattern) {
            this(pattern.startsWith("!") ? pattern.substring(1) : pattern, pattern.startsWith("!"));
        }

        SimplePatternBasedHeaderMatcher(String pattern, boolean negate) {
            Assert.notNull((Object)pattern, (String)"Pattern must no be null");
            this.pattern = pattern.toLowerCase();
            this.negate = negate;
        }

        public boolean matchHeader(String headerName) {
            String header = headerName.toLowerCase();
            if (PatternMatchUtils.simpleMatch((String)this.pattern, (String)header)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL " + (this.negate ? "NOT " : "") + "be mapped, matched pattern=" + (this.negate ? "!" : "") + "{1}", headerName, this.pattern));
                }
                return true;
            }
            return false;
        }

        public boolean isNegated() {
            return this.negate;
        }
    }
}

