/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.kafka.support.ProducerListener;
import org.springframework.util.ObjectUtils;

public class LoggingProducerListener<K, V>
implements ProducerListener<K, V> {
    public static final int DEFAULT_MAX_CONTENT_LOGGED = 100;
    private static final Log logger = LogFactory.getLog(LoggingProducerListener.class);
    private boolean includeContents = true;
    private int maxContentLogged = 100;

    public void setIncludeContents(boolean includeContents) {
        this.includeContents = includeContents;
    }

    public void setMaxContentLogged(int maxContentLogged) {
        this.maxContentLogged = maxContentLogged;
    }

    @Override
    public void onError(String topic, Integer partition, K key, V value, Exception exception) {
        if (logger.isErrorEnabled()) {
            StringBuffer logOutput = new StringBuffer();
            logOutput.append("Exception thrown when sending a message");
            if (this.includeContents) {
                logOutput.append(" with key='").append(this.toDisplayString(ObjectUtils.nullSafeToString(key), this.maxContentLogged)).append("'").append(" and payload='").append(this.toDisplayString(ObjectUtils.nullSafeToString(value), this.maxContentLogged)).append("'");
            }
            logOutput.append(" to topic ").append(topic);
            if (partition != null) {
                logOutput.append(" and partition ").append(partition);
            }
            logOutput.append(":");
            logger.error((Object)logOutput, (Throwable)exception);
        }
    }

    private String toDisplayString(String original, int maxCharacters) {
        if (original.length() <= maxCharacters) {
            return original;
        }
        return original.substring(0, maxCharacters) + "...";
    }
}

