/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.mockmvc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.springframework.restdocs.mockmvc.IterableEnumeration;
import org.springframework.restdocs.mockmvc.MockMvcOperationRequestFactory;
import org.springframework.restdocs.mockmvc.MockMvcOperationResponseFactory;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationResponse;
import org.springframework.restdocs.operation.StandardOperation;
import org.springframework.restdocs.operation.preprocess.OperationRequestPreprocessor;
import org.springframework.restdocs.operation.preprocess.OperationResponsePreprocessor;
import org.springframework.restdocs.snippet.Snippet;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.util.Assert;

public class RestDocumentationResultHandler
implements ResultHandler {
    private final String identifier;
    private final OperationRequestPreprocessor requestPreprocessor;
    private final OperationResponsePreprocessor responsePreprocessor;
    private final List<Snippet> snippets;

    RestDocumentationResultHandler(String identifier, Snippet ... snippets) {
        this(identifier, (OperationRequestPreprocessor)new IdentityOperationRequestPreprocessor(), new IdentityOperationResponsePreprocessor(), snippets);
    }

    RestDocumentationResultHandler(String identifier, OperationRequestPreprocessor requestPreprocessor, Snippet ... snippets) {
        this(identifier, requestPreprocessor, new IdentityOperationResponsePreprocessor(), snippets);
    }

    RestDocumentationResultHandler(String identifier, OperationResponsePreprocessor responsePreprocessor, Snippet ... snippets) {
        this(identifier, (OperationRequestPreprocessor)new IdentityOperationRequestPreprocessor(), responsePreprocessor, snippets);
    }

    RestDocumentationResultHandler(String identifier, OperationRequestPreprocessor requestPreprocessor, OperationResponsePreprocessor responsePreprocessor, Snippet ... snippets) {
        Assert.notNull((Object)identifier, (String)"identifier must be non-null");
        Assert.notNull((Object)requestPreprocessor, (String)"requestPreprocessor must be non-null");
        Assert.notNull((Object)responsePreprocessor, (String)"responsePreprocessor must be non-null");
        Assert.notNull((Object)snippets, (String)"snippets must be non-null");
        this.identifier = identifier;
        this.requestPreprocessor = requestPreprocessor;
        this.responsePreprocessor = responsePreprocessor;
        this.snippets = new ArrayList<Snippet>(Arrays.asList(snippets));
    }

    public void handle(MvcResult result) throws Exception {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (String name : IterableEnumeration.iterable(result.getRequest().getAttributeNames())) {
            attributes.put(name, result.getRequest().getAttribute(name));
        }
        OperationRequest request = this.requestPreprocessor.preprocess(new MockMvcOperationRequestFactory().createOperationRequest(result.getRequest()));
        OperationResponse response = this.responsePreprocessor.preprocess(new MockMvcOperationResponseFactory().createOperationResponse(result.getResponse()));
        StandardOperation operation = new StandardOperation(this.identifier, request, response, attributes);
        for (Snippet snippet : this.getSnippets(result)) {
            snippet.document((Operation)operation);
        }
    }

    public RestDocumentationResultHandler snippets(Snippet ... snippets) {
        this.snippets.addAll(Arrays.asList(snippets));
        return this;
    }

    private List<Snippet> getSnippets(MvcResult result) {
        ArrayList<Snippet> combinedSnippets = new ArrayList<Snippet>((List)result.getRequest().getAttribute("org.springframework.restdocs.mockmvc.defaultSnippets"));
        combinedSnippets.addAll(this.snippets);
        return combinedSnippets;
    }

    private static final class IdentityOperationResponsePreprocessor
    implements OperationResponsePreprocessor {
        private IdentityOperationResponsePreprocessor() {
        }

        public OperationResponse preprocess(OperationResponse response) {
            return response;
        }
    }

    private static final class IdentityOperationRequestPreprocessor
    implements OperationRequestPreprocessor {
        private IdentityOperationRequestPreprocessor() {
        }

        public OperationRequest preprocess(OperationRequest request) {
            return request;
        }
    }
}

