/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token.store;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPublicKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;

@Deprecated
public class KeyStoreKeyFactory {
    private static final Log logger = LogFactory.getLog(KeyStoreKeyFactory.class);
    private Resource resource;
    private char[] password;
    private KeyStore store;
    private Object lock = new Object();

    public KeyStoreKeyFactory(Resource resource, char[] password) {
        this.resource = resource;
        this.password = password;
    }

    public KeyPair getKeyPair(String alias) {
        return this.getKeyPair(alias, this.password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyPair getKeyPair(String alias, char[] password) {
        InputStream inputStream = null;
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.store == null) {
                    Object object2 = this.lock;
                    synchronized (object2) {
                        this.store = KeyStore.getInstance("jks");
                        inputStream = this.resource.getInputStream();
                        this.store.load(inputStream, this.password);
                    }
                }
            }
            RSAPrivateCrtKey key = (RSAPrivateCrtKey)this.store.getKey(alias, password);
            RSAPublicKeySpec spec = new RSAPublicKeySpec(key.getModulus(), key.getPublicExponent());
            PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(spec);
            KeyPair keyPair = new KeyPair(publicKey, key);
            return keyPair;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot load keys from store: " + this.resource, e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                logger.warn((Object)"Cannot close open stream: ", (Throwable)e);
            }
        }
    }
}

