/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsent;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthenticationContext;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.util.Assert;

public final class OAuth2AuthorizationCodeRequestAuthenticationContext
implements OAuth2AuthenticationContext {
    private final Map<Object, Object> context;

    private OAuth2AuthorizationCodeRequestAuthenticationContext(Map<Object, Object> context) {
        this.context = Collections.unmodifiableMap(new HashMap<Object, Object>(context));
    }

    @Override
    @Nullable
    public <V> V get(Object key) {
        return (V)(this.hasKey(key) ? this.context.get(key) : null);
    }

    @Override
    public boolean hasKey(Object key) {
        Assert.notNull((Object)key, (String)"key cannot be null");
        return this.context.containsKey(key);
    }

    public RegisteredClient getRegisteredClient() {
        return this.get(RegisteredClient.class);
    }

    @Nullable
    public OAuth2AuthorizationRequest getAuthorizationRequest() {
        return this.get(OAuth2AuthorizationRequest.class);
    }

    @Nullable
    public OAuth2AuthorizationConsent getAuthorizationConsent() {
        return this.get(OAuth2AuthorizationConsent.class);
    }

    public static Builder with(OAuth2AuthorizationCodeRequestAuthenticationToken authentication) {
        return new Builder(authentication);
    }

    public static final class Builder
    extends OAuth2AuthenticationContext.AbstractBuilder<OAuth2AuthorizationCodeRequestAuthenticationContext, Builder> {
        private Builder(OAuth2AuthorizationCodeRequestAuthenticationToken authentication) {
            super((Authentication)authentication);
        }

        public Builder registeredClient(RegisteredClient registeredClient) {
            return (Builder)this.put(RegisteredClient.class, registeredClient);
        }

        public Builder authorizationRequest(OAuth2AuthorizationRequest authorizationRequest) {
            return (Builder)this.put(OAuth2AuthorizationRequest.class, authorizationRequest);
        }

        public Builder authorizationConsent(OAuth2AuthorizationConsent authorizationConsent) {
            return (Builder)this.put(OAuth2AuthorizationConsent.class, authorizationConsent);
        }

        @Override
        public OAuth2AuthorizationCodeRequestAuthenticationContext build() {
            Assert.notNull(this.get(RegisteredClient.class), (String)"registeredClient cannot be null");
            return new OAuth2AuthorizationCodeRequestAuthenticationContext(this.getContext());
        }
    }
}

