/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.authentication.CodeVerifierAuthenticator;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationContext;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.X509SelfSignedCertificateVerifier;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class X509ClientCertificateAuthenticationProvider
implements AuthenticationProvider {
    private static final String ERROR_URI = "https://datatracker.ietf.org/doc/html/rfc6749#section-3.2.1";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final RegisteredClientRepository registeredClientRepository;
    private final CodeVerifierAuthenticator codeVerifierAuthenticator;
    private final Consumer<OAuth2ClientAuthenticationContext> selfSignedCertificateVerifier = new X509SelfSignedCertificateVerifier();
    private Consumer<OAuth2ClientAuthenticationContext> certificateVerifier = this::verifyX509Certificate;

    public X509ClientCertificateAuthenticationProvider(RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationService authorizationService) {
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        this.registeredClientRepository = registeredClientRepository;
        this.codeVerifierAuthenticator = new CodeVerifierAuthenticator(authorizationService);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OAuth2ClientAuthenticationToken clientAuthentication = (OAuth2ClientAuthenticationToken)authentication;
        if (!ClientAuthenticationMethod.TLS_CLIENT_AUTH.equals((Object)clientAuthentication.getClientAuthenticationMethod()) && !ClientAuthenticationMethod.SELF_SIGNED_TLS_CLIENT_AUTH.equals((Object)clientAuthentication.getClientAuthenticationMethod())) {
            return null;
        }
        String clientId = clientAuthentication.getPrincipal().toString();
        RegisteredClient registeredClient = this.registeredClientRepository.findByClientId(clientId);
        if (registeredClient == null) {
            X509ClientCertificateAuthenticationProvider.throwInvalidClient("client_id");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Retrieved registered client");
        }
        if (!registeredClient.getClientAuthenticationMethods().contains(clientAuthentication.getClientAuthenticationMethod())) {
            X509ClientCertificateAuthenticationProvider.throwInvalidClient("authentication_method");
        }
        if (!(clientAuthentication.getCredentials() instanceof X509Certificate[])) {
            X509ClientCertificateAuthenticationProvider.throwInvalidClient("credentials");
        }
        OAuth2ClientAuthenticationContext authenticationContext = OAuth2ClientAuthenticationContext.with(clientAuthentication).registeredClient(registeredClient).build();
        this.certificateVerifier.accept(authenticationContext);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Validated client authentication parameters");
        }
        this.codeVerifierAuthenticator.authenticateIfAvailable(clientAuthentication, registeredClient);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Authenticated client X509Certificate");
        }
        return new OAuth2ClientAuthenticationToken(registeredClient, clientAuthentication.getClientAuthenticationMethod(), clientAuthentication.getCredentials());
    }

    public boolean supports(Class<?> authentication) {
        return OAuth2ClientAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public void setCertificateVerifier(Consumer<OAuth2ClientAuthenticationContext> certificateVerifier) {
        Assert.notNull(certificateVerifier, (String)"certificateVerifier cannot be null");
        this.certificateVerifier = certificateVerifier;
    }

    private void verifyX509Certificate(OAuth2ClientAuthenticationContext clientAuthenticationContext) {
        OAuth2ClientAuthenticationToken clientAuthentication = (OAuth2ClientAuthenticationToken)((Object)clientAuthenticationContext.getAuthentication());
        if (ClientAuthenticationMethod.SELF_SIGNED_TLS_CLIENT_AUTH.equals((Object)clientAuthentication.getClientAuthenticationMethod())) {
            this.selfSignedCertificateVerifier.accept(clientAuthenticationContext);
        } else {
            this.verifyX509CertificateSubjectDN(clientAuthenticationContext);
        }
    }

    private void verifyX509CertificateSubjectDN(OAuth2ClientAuthenticationContext clientAuthenticationContext) {
        OAuth2ClientAuthenticationToken clientAuthentication = (OAuth2ClientAuthenticationToken)((Object)clientAuthenticationContext.getAuthentication());
        RegisteredClient registeredClient = clientAuthenticationContext.getRegisteredClient();
        X509Certificate[] clientCertificateChain = (X509Certificate[])clientAuthentication.getCredentials();
        X509Certificate clientCertificate = clientCertificateChain[0];
        String expectedSubjectDN = registeredClient.getClientSettings().getX509CertificateSubjectDN();
        if (!StringUtils.hasText((String)expectedSubjectDN) || !clientCertificate.getSubjectX500Principal().getName().equals(expectedSubjectDN)) {
            X509ClientCertificateAuthenticationProvider.throwInvalidClient("x509_certificate_subject_dn");
        }
    }

    private static void throwInvalidClient(String parameterName) {
        X509ClientCertificateAuthenticationProvider.throwInvalidClient(parameterName, null);
    }

    private static void throwInvalidClient(String parameterName, Throwable cause) {
        OAuth2Error error = new OAuth2Error("invalid_client", "Client authentication failed: " + parameterName, ERROR_URI);
        throw new OAuth2AuthenticationException(error, error.toString(), cause);
    }
}

