/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web.authentication;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

final class OAuth2EndpointUtils {
    static final String ACCESS_TOKEN_REQUEST_ERROR_URI = "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2";

    private OAuth2EndpointUtils() {
    }

    static MultiValueMap<String, String> getFormParameters(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameterMap.forEach((arg_0, arg_1) -> OAuth2EndpointUtils.lambda$getFormParameters$0(request, (MultiValueMap)parameters, arg_0, arg_1));
        return parameters;
    }

    static MultiValueMap<String, String> getQueryParameters(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameterMap.forEach((arg_0, arg_1) -> OAuth2EndpointUtils.lambda$getQueryParameters$1(request, (MultiValueMap)parameters, arg_0, arg_1));
        return parameters;
    }

    static Map<String, Object> getParametersIfMatchesAuthorizationCodeGrantRequest(HttpServletRequest request, String ... exclusions) {
        if (!OAuth2EndpointUtils.matchesAuthorizationCodeGrantRequest(request)) {
            return Collections.emptyMap();
        }
        MultiValueMap<String, String> multiValueParameters = "GET".equals(request.getMethod()) ? OAuth2EndpointUtils.getQueryParameters(request) : OAuth2EndpointUtils.getFormParameters(request);
        for (String exclusion : exclusions) {
            multiValueParameters.remove((Object)exclusion);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        multiValueParameters.forEach((key, value) -> parameters.put((String)key, value.size() == 1 ? value.get(0) : value.toArray(new String[0])));
        return parameters;
    }

    static boolean matchesAuthorizationCodeGrantRequest(HttpServletRequest request) {
        return AuthorizationGrantType.AUTHORIZATION_CODE.getValue().equals(request.getParameter("grant_type")) && request.getParameter("code") != null;
    }

    static boolean matchesPkceTokenRequest(HttpServletRequest request) {
        return OAuth2EndpointUtils.matchesAuthorizationCodeGrantRequest(request) && request.getParameter("code_verifier") != null;
    }

    static void throwError(String errorCode, String parameterName, String errorUri) {
        OAuth2Error error = new OAuth2Error(errorCode, "OAuth 2.0 Parameter: " + parameterName, errorUri);
        throw new OAuth2AuthenticationException(error);
    }

    static String normalizeUserCode(String userCode) {
        Assert.hasText((String)userCode, (String)"userCode cannot be empty");
        StringBuilder sb = new StringBuilder(userCode.toUpperCase(Locale.ENGLISH).replaceAll("[^A-Z\\d]+", ""));
        Assert.isTrue((sb.length() == 8 ? 1 : 0) != 0, (String)"userCode must be exactly 8 alpha/numeric characters");
        sb.insert(4, '-');
        return sb.toString();
    }

    static boolean validateUserCode(String userCode) {
        return userCode != null && userCode.toUpperCase(Locale.ENGLISH).replaceAll("[^A-Z\\d]+", "").length() == 8;
    }

    private static /* synthetic */ void lambda$getQueryParameters$1(HttpServletRequest request, MultiValueMap parameters, String key, String[] values) {
        String queryString;
        String string = queryString = StringUtils.hasText((String)request.getQueryString()) ? request.getQueryString() : "";
        if (queryString.contains(key) && values.length > 0) {
            for (String value : values) {
                parameters.add((Object)key, (Object)value);
            }
        }
    }

    private static /* synthetic */ void lambda$getFormParameters$0(HttpServletRequest request, MultiValueMap parameters, String key, String[] values) {
        String queryString;
        String string = queryString = StringUtils.hasText((String)request.getQueryString()) ? request.getQueryString() : "";
        if (!queryString.contains(key) && values.length > 0) {
            for (String value : values) {
                parameters.add((Object)key, (Object)value);
            }
        }
    }
}

