/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.ClientAuthorizationException;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizationFailureHandler;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class RemoveAuthorizedClientReactiveOAuth2AuthorizationFailureHandler
implements ReactiveOAuth2AuthorizationFailureHandler {
    public static final Set<String> DEFAULT_REMOVE_AUTHORIZED_CLIENT_ERROR_CODES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("invalid_token", "invalid_grant")));
    private final OAuth2AuthorizedClientRemover delegate;
    private final Set<String> removeAuthorizedClientErrorCodes;

    public RemoveAuthorizedClientReactiveOAuth2AuthorizationFailureHandler(OAuth2AuthorizedClientRemover authorizedClientRemover) {
        this(authorizedClientRemover, DEFAULT_REMOVE_AUTHORIZED_CLIENT_ERROR_CODES);
    }

    public RemoveAuthorizedClientReactiveOAuth2AuthorizationFailureHandler(OAuth2AuthorizedClientRemover authorizedClientRemover, Set<String> removeAuthorizedClientErrorCodes) {
        Assert.notNull((Object)authorizedClientRemover, (String)"authorizedClientRemover cannot be null");
        Assert.notNull(removeAuthorizedClientErrorCodes, (String)"removeAuthorizedClientErrorCodes cannot be null");
        this.removeAuthorizedClientErrorCodes = Collections.unmodifiableSet(new HashSet<String>(removeAuthorizedClientErrorCodes));
        this.delegate = authorizedClientRemover;
    }

    @Override
    public Mono<Void> onAuthorizationFailure(OAuth2AuthorizationException authorizationException, Authentication principal, Map<String, Object> attributes) {
        if (authorizationException instanceof ClientAuthorizationException && this.hasRemovalErrorCode(authorizationException)) {
            ClientAuthorizationException clientAuthorizationException = (ClientAuthorizationException)authorizationException;
            return this.delegate.removeAuthorizedClient(clientAuthorizationException.getClientRegistrationId(), principal, attributes);
        }
        return Mono.empty();
    }

    private boolean hasRemovalErrorCode(OAuth2AuthorizationException authorizationException) {
        return this.removeAuthorizedClientErrorCodes.contains(authorizationException.getError().getErrorCode());
    }

    @FunctionalInterface
    public static interface OAuth2AuthorizedClientRemover {
        public Mono<Void> removeAuthorizedClient(String var1, Authentication var2, Map<String, Object> var3);
    }
}

