/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.util.Assert;

public class OAuth2RefreshTokenGrantRequest
extends AbstractOAuth2AuthorizationGrantRequest {
    private final ClientRegistration clientRegistration;
    private final OAuth2AccessToken accessToken;
    private final OAuth2RefreshToken refreshToken;
    private final Set<String> scopes;

    public OAuth2RefreshTokenGrantRequest(ClientRegistration clientRegistration, OAuth2AccessToken accessToken, OAuth2RefreshToken refreshToken) {
        this(clientRegistration, accessToken, refreshToken, Collections.emptySet());
    }

    public OAuth2RefreshTokenGrantRequest(ClientRegistration clientRegistration, OAuth2AccessToken accessToken, OAuth2RefreshToken refreshToken, Set<String> scopes) {
        super(AuthorizationGrantType.REFRESH_TOKEN);
        Assert.notNull((Object)clientRegistration, (String)"clientRegistration cannot be null");
        Assert.notNull((Object)accessToken, (String)"accessToken cannot be null");
        Assert.notNull((Object)refreshToken, (String)"refreshToken cannot be null");
        this.clientRegistration = clientRegistration;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.scopes = Collections.unmodifiableSet(scopes != null ? new LinkedHashSet<String>(scopes) : Collections.emptySet());
    }

    public ClientRegistration getClientRegistration() {
        return this.clientRegistration;
    }

    public OAuth2AccessToken getAccessToken() {
        return this.accessToken;
    }

    public OAuth2RefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }
}

