/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.io.Serializable;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.util.Assert;

public class OAuth2AuthorizedClient
implements Serializable {
    private static final long serialVersionUID = 610L;
    private final ClientRegistration clientRegistration;
    private final String principalName;
    private final OAuth2AccessToken accessToken;
    private final OAuth2RefreshToken refreshToken;

    public OAuth2AuthorizedClient(ClientRegistration clientRegistration, String principalName, OAuth2AccessToken accessToken) {
        this(clientRegistration, principalName, accessToken, null);
    }

    public OAuth2AuthorizedClient(ClientRegistration clientRegistration, String principalName, OAuth2AccessToken accessToken, @Nullable OAuth2RefreshToken refreshToken) {
        Assert.notNull((Object)clientRegistration, (String)"clientRegistration cannot be null");
        Assert.hasText((String)principalName, (String)"principalName cannot be empty");
        Assert.notNull((Object)accessToken, (String)"accessToken cannot be null");
        this.clientRegistration = clientRegistration;
        this.principalName = principalName;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
    }

    public ClientRegistration getClientRegistration() {
        return this.clientRegistration;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public OAuth2AccessToken getAccessToken() {
        return this.accessToken;
    }

    @Nullable
    public OAuth2RefreshToken getRefreshToken() {
        return this.refreshToken;
    }
}

