/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.context.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.test.context.TestSecurityContextHolder;
import org.springframework.security.test.context.support.WithSecurityContext;
import org.springframework.security.test.context.support.WithSecurityContextFactory;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Order(value=1000)
public class WithSecurityContextTestExecutionListener
extends AbstractTestExecutionListener {
    public void beforeTestMethod(TestContext testContext) throws Exception {
        Annotation[] methodAnnotations = AnnotationUtils.getAnnotations((Method)testContext.getTestMethod());
        SecurityContext securityContext = this.createSecurityContext(methodAnnotations, testContext);
        if (securityContext == null) {
            Annotation[] classAnnotations = testContext.getTestClass().getAnnotations();
            securityContext = this.createSecurityContext(classAnnotations, testContext);
        }
        if (securityContext != null) {
            TestSecurityContextHolder.setContext(securityContext);
        }
    }

    private SecurityContext createSecurityContext(Annotation[] annotations, TestContext context) {
        for (Annotation a : annotations) {
            WithSecurityContext withUser = (WithSecurityContext)AnnotationUtils.findAnnotation(a.annotationType(), WithSecurityContext.class);
            if (withUser == null) continue;
            WithSecurityContextFactory<? extends Annotation> factory = this.createFactory(withUser, context);
            try {
                return factory.createSecurityContext(a);
            }
            catch (RuntimeException e) {
                throw new IllegalStateException("Unable to create SecurityContext using " + a, e);
            }
        }
        return null;
    }

    private WithSecurityContextFactory<? extends Annotation> createFactory(WithSecurityContext withUser, TestContext testContext) {
        Class<? extends WithSecurityContextFactory<? extends Annotation>> clazz = withUser.factory();
        try {
            return (WithSecurityContextFactory)testContext.getApplicationContext().getAutowireCapableBeanFactory().createBean(clazz);
        }
        catch (IllegalStateException e) {
            return (WithSecurityContextFactory)BeanUtils.instantiateClass(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        TestSecurityContextHolder.clearContext();
    }
}

