/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.context;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class SaveContextOnUpdateOrErrorResponseWrapper
extends HttpServletResponseWrapper {
    private boolean contextSaved = false;
    private final boolean disableUrlRewriting;

    public SaveContextOnUpdateOrErrorResponseWrapper(HttpServletResponse response, boolean disableUrlRewriting) {
        super(response);
        this.disableUrlRewriting = disableUrlRewriting;
    }

    protected abstract void saveContext(SecurityContext var1);

    public final void sendError(int sc) throws IOException {
        this.doSaveContext();
        super.sendError(sc);
    }

    public final void sendError(int sc, String msg) throws IOException {
        this.doSaveContext();
        super.sendError(sc, msg);
    }

    public final void sendRedirect(String location) throws IOException {
        this.doSaveContext();
        super.sendRedirect(location);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new SaveContextServletOutputStream(super.getOutputStream());
    }

    public PrintWriter getWriter() throws IOException {
        return new SaveContextPrintWriter(super.getWriter());
    }

    public void flushBuffer() throws IOException {
        this.doSaveContext();
        super.flushBuffer();
    }

    private void doSaveContext() {
        this.saveContext(SecurityContextHolder.getContext());
        this.contextSaved = true;
    }

    public final String encodeRedirectUrl(String url) {
        if (this.disableUrlRewriting) {
            return url;
        }
        return super.encodeRedirectUrl(url);
    }

    public final String encodeRedirectURL(String url) {
        if (this.disableUrlRewriting) {
            return url;
        }
        return super.encodeRedirectURL(url);
    }

    public final String encodeUrl(String url) {
        if (this.disableUrlRewriting) {
            return url;
        }
        return super.encodeUrl(url);
    }

    public final String encodeURL(String url) {
        if (this.disableUrlRewriting) {
            return url;
        }
        return super.encodeURL(url);
    }

    public final boolean isContextSaved() {
        return this.contextSaved;
    }

    private class SaveContextServletOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream delegate;

        public SaveContextServletOutputStream(ServletOutputStream delegate) {
            this.delegate = delegate;
        }

        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        public void flush() throws IOException {
            SaveContextOnUpdateOrErrorResponseWrapper.this.doSaveContext();
            super.flush();
        }

        public void close() throws IOException {
            SaveContextOnUpdateOrErrorResponseWrapper.this.doSaveContext();
            super.close();
        }
    }

    private class SaveContextPrintWriter
    extends PrintWriter {
        public SaveContextPrintWriter(Writer out) {
            super(out);
        }

        public void flush() {
            SaveContextOnUpdateOrErrorResponseWrapper.this.doSaveContext();
            super.flush();
        }

        public void close() {
            SaveContextOnUpdateOrErrorResponseWrapper.this.doSaveContext();
            super.close();
        }
    }
}

