/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication;

import java.util.List;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.session.ReactiveSessionInformation;
import org.springframework.security.core.session.ReactiveSessionRegistry;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.InvalidateLeastUsedServerMaximumSessionsExceededHandler;
import org.springframework.security.web.server.authentication.MaximumSessionsContext;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.ServerMaximumSessionsExceededHandler;
import org.springframework.security.web.server.authentication.SessionLimit;
import org.springframework.util.Assert;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuples;

public final class ConcurrentSessionControlServerAuthenticationSuccessHandler
implements ServerAuthenticationSuccessHandler {
    private final ReactiveSessionRegistry sessionRegistry;
    private SessionLimit sessionLimit = SessionLimit.of(1);
    private ServerMaximumSessionsExceededHandler maximumSessionsExceededHandler = new InvalidateLeastUsedServerMaximumSessionsExceededHandler();

    public ConcurrentSessionControlServerAuthenticationSuccessHandler(ReactiveSessionRegistry sessionRegistry) {
        Assert.notNull((Object)sessionRegistry, (String)"sessionRegistry cannot be null");
        this.sessionRegistry = sessionRegistry;
    }

    @Override
    public Mono<Void> onAuthenticationSuccess(WebFilterExchange exchange, Authentication authentication) {
        return ((Mono)this.sessionLimit.apply(authentication)).flatMap(maxSessions -> this.handleConcurrency(exchange, authentication, (Integer)maxSessions));
    }

    private Mono<Void> handleConcurrency(WebFilterExchange exchange, Authentication authentication, Integer maximumSessions) {
        return this.sessionRegistry.getAllSessions(authentication.getPrincipal(), false).collectList().flatMap(registeredSessions -> exchange.getExchange().getSession().map(currentSession -> Tuples.of((Object)currentSession, (Object)registeredSessions))).flatMap(sessionTuple -> {
            WebSession currentSession = (WebSession)sessionTuple.getT1();
            List registeredSessions = (List)sessionTuple.getT2();
            int registeredSessionsCount = registeredSessions.size();
            if (registeredSessionsCount < maximumSessions) {
                return Mono.empty();
            }
            if (registeredSessionsCount == maximumSessions) {
                for (ReactiveSessionInformation registeredSession : registeredSessions) {
                    if (!registeredSession.getSessionId().equals(currentSession.getId())) continue;
                    return Mono.empty();
                }
            }
            return this.maximumSessionsExceededHandler.handle(new MaximumSessionsContext(authentication, registeredSessions, maximumSessions));
        });
    }

    public void setSessionLimit(SessionLimit sessionLimit) {
        Assert.notNull((Object)sessionLimit, (String)"sessionLimit cannot be null");
        this.sessionLimit = sessionLimit;
    }

    public void setMaximumSessionsExceededHandler(ServerMaximumSessionsExceededHandler maximumSessionsExceededHandler) {
        Assert.notNull((Object)maximumSessionsExceededHandler, (String)"maximumSessionsExceededHandler cannot be null");
        this.maximumSessionsExceededHandler = maximumSessionsExceededHandler;
    }
}

