/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.security.core.session.ReactiveSessionInformation;
import org.springframework.security.web.server.authentication.MaximumSessionsContext;
import org.springframework.security.web.server.authentication.ServerMaximumSessionsExceededHandler;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class InvalidateLeastUsedServerMaximumSessionsExceededHandler
implements ServerMaximumSessionsExceededHandler {
    private final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public Mono<Void> handle(MaximumSessionsContext context) {
        ArrayList<ReactiveSessionInformation> sessions = new ArrayList<ReactiveSessionInformation>(context.getSessions());
        sessions.sort(Comparator.comparing(ReactiveSessionInformation::getLastAccessTime));
        int maximumSessionsExceededBy = sessions.size() - context.getMaximumSessionsAllowed() + 1;
        List leastRecentlyUsedSessionsToInvalidate = sessions.subList(0, maximumSessionsExceededBy);
        return Flux.fromIterable(leastRecentlyUsedSessionsToInvalidate).doOnComplete(() -> this.logger.debug((Object)LogMessage.format((String)"Invalidated %d least recently used sessions for authentication %s", (Object)leastRecentlyUsedSessionsToInvalidate.size(), (Object)context.getAuthentication().getName()))).flatMap(ReactiveSessionInformation::invalidate).then();
    }
}

