/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.session;

import org.springframework.security.core.session.InMemoryReactiveSessionRegistry;
import org.springframework.security.core.session.ReactiveSessionInformation;
import org.springframework.security.core.session.ReactiveSessionRegistry;
import org.springframework.util.Assert;
import org.springframework.web.server.WebSession;
import org.springframework.web.server.session.WebSessionStore;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class WebSessionStoreReactiveSessionRegistry
implements ReactiveSessionRegistry {
    private final WebSessionStore webSessionStore;
    private ReactiveSessionRegistry sessionRegistry = new InMemoryReactiveSessionRegistry();

    public WebSessionStoreReactiveSessionRegistry(WebSessionStore webSessionStore) {
        Assert.notNull((Object)webSessionStore, (String)"webSessionStore cannot be null");
        this.webSessionStore = webSessionStore;
    }

    public Flux<ReactiveSessionInformation> getAllSessions(Object principal, boolean includeExpiredSessions) {
        return this.sessionRegistry.getAllSessions(principal, includeExpiredSessions).map(x$0 -> new WebSessionInformation((ReactiveSessionInformation)x$0));
    }

    public Mono<Void> saveSessionInformation(ReactiveSessionInformation information) {
        return this.sessionRegistry.saveSessionInformation((ReactiveSessionInformation)new WebSessionInformation(information));
    }

    public Mono<ReactiveSessionInformation> getSessionInformation(String sessionId) {
        return this.sessionRegistry.getSessionInformation(sessionId).map(x$0 -> new WebSessionInformation((ReactiveSessionInformation)x$0));
    }

    public Mono<ReactiveSessionInformation> removeSessionInformation(String sessionId) {
        return this.sessionRegistry.removeSessionInformation(sessionId).map(x$0 -> new WebSessionInformation((ReactiveSessionInformation)x$0));
    }

    public Mono<ReactiveSessionInformation> updateLastAccessTime(String sessionId) {
        return this.sessionRegistry.updateLastAccessTime(sessionId).map(x$0 -> new WebSessionInformation((ReactiveSessionInformation)x$0));
    }

    public void setSessionRegistry(ReactiveSessionRegistry sessionRegistry) {
        Assert.notNull((Object)sessionRegistry, (String)"sessionRegistry cannot be null");
        this.sessionRegistry = sessionRegistry;
    }

    final class WebSessionInformation
    extends ReactiveSessionInformation {
        WebSessionInformation(ReactiveSessionInformation sessionInformation) {
            super(sessionInformation.getPrincipal(), sessionInformation.getSessionId(), sessionInformation.getLastAccessTime());
        }

        public Mono<Void> invalidate() {
            return WebSessionStoreReactiveSessionRegistry.this.webSessionStore.retrieveSession(this.getSessionId()).flatMap(WebSession::invalidate).then(Mono.defer(() -> WebSessionStoreReactiveSessionRegistry.this.removeSessionInformation(this.getSessionId()))).then(Mono.defer(() -> super.invalidate()));
        }
    }
}

