/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.password;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.password.CompromisedPasswordCheckResult;
import org.springframework.security.authentication.password.ReactiveCompromisedPasswordChecker;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class HaveIBeenPwnedRestApiReactivePasswordChecker
implements ReactiveCompromisedPasswordChecker {
    private static final String API_URL = "https://api.pwnedpasswords.com/range/";
    private static final int PREFIX_LENGTH = 5;
    private final Log logger = LogFactory.getLog(this.getClass());
    private WebClient webClient = WebClient.builder().baseUrl("https://api.pwnedpasswords.com/range/").build();
    private final MessageDigest sha1Digest = HaveIBeenPwnedRestApiReactivePasswordChecker.getSha1Digest();

    public Mono<CompromisedPasswordCheckResult> check(String password) {
        return this.getHash(password).map(hash -> new String(Hex.encode((byte[])hash))).flatMap(this::findLeakedPassword).map(CompromisedPasswordCheckResult::new);
    }

    private Mono<Boolean> findLeakedPassword(String encodedPassword) {
        String prefix = encodedPassword.substring(0, 5).toUpperCase();
        String suffix = encodedPassword.substring(5).toUpperCase();
        return this.getLeakedPasswordsForPrefix(prefix).any(leakedPw -> leakedPw.startsWith(suffix));
    }

    private Flux<String> getLeakedPasswordsForPrefix(String prefix) {
        return this.webClient.get().uri(prefix, new Object[0]).retrieve().bodyToMono(String.class).flatMapMany(body -> {
            if (StringUtils.hasText((String)body)) {
                return Flux.fromStream(body.lines());
            }
            return Flux.empty();
        }).doOnError(ex -> this.logger.error((Object)"Request for leaked passwords failed", ex)).onErrorResume(WebClientResponseException.class, ex -> Flux.empty());
    }

    public void setWebClient(WebClient webClient) {
        Assert.notNull((Object)webClient, (String)"webClient cannot be null");
        this.webClient = webClient;
    }

    private Mono<byte[]> getHash(String password) {
        return Mono.fromSupplier(() -> this.sha1Digest.digest(password.getBytes(StandardCharsets.UTF_8))).subscribeOn(Schedulers.boundedElastic()).publishOn(Schedulers.parallel());
    }

    private static MessageDigest getSha1Digest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }
}

