/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.security.core.session.ReactiveSessionInformation;
import org.springframework.security.web.server.authentication.MaximumSessionsContext;
import org.springframework.security.web.server.authentication.ServerMaximumSessionsExceededHandler;
import org.springframework.web.server.session.WebSessionStore;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class InvalidateLeastUsedServerMaximumSessionsExceededHandler
implements ServerMaximumSessionsExceededHandler {
    private final WebSessionStore webSessionStore;

    public InvalidateLeastUsedServerMaximumSessionsExceededHandler(WebSessionStore webSessionStore) {
        this.webSessionStore = webSessionStore;
    }

    @Override
    public Mono<Void> handle(MaximumSessionsContext context) {
        ArrayList<ReactiveSessionInformation> sessions = new ArrayList<ReactiveSessionInformation>(context.getSessions());
        sessions.sort(Comparator.comparing(ReactiveSessionInformation::getLastAccessTime));
        int maximumSessionsExceededBy = sessions.size() - context.getMaximumSessionsAllowed() + 1;
        List leastRecentlyUsedSessionsToInvalidate = sessions.subList(0, maximumSessionsExceededBy);
        return Flux.fromIterable(leastRecentlyUsedSessionsToInvalidate).flatMap(toInvalidate -> toInvalidate.invalidate().thenReturn(toInvalidate)).flatMap(toInvalidate -> this.webSessionStore.removeSession(toInvalidate.getSessionId())).then();
    }
}

