/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.converters;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;
import org.springframework.stereotype.Component;

@Component
public class DateConverter
implements Converter<Date> {
    private final DateFormat dateFormat;

    public DateConverter() {
        this.dateFormat = DateFormat.getDateInstance(2, Locale.getDefault());
    }

    public DateConverter(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    public Date convertFromText(String value, Class<?> requiredType, String optionContext) {
        try {
            return this.dateFormat.parse(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not parse date: " + e.getMessage());
        }
    }

    @Override
    public boolean getAllPossibleValues(List<Completion> completions, Class<?> requiredType, String existingData, String optionContext, MethodTarget target) {
        return false;
    }

    @Override
    public boolean supports(Class<?> requiredType, String optionContext) {
        return Date.class.isAssignableFrom(requiredType);
    }
}

