/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanTypeDescriptor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.core.CollectionFactory;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TypeConverterDelegate {
    private static final Log logger = LogFactory.getLog(TypeConverterDelegate.class);
    private final PropertyEditorRegistrySupport propertyEditorRegistry;
    private final Object targetObject;

    public TypeConverterDelegate(PropertyEditorRegistrySupport propertyEditorRegistry) {
        this(propertyEditorRegistry, null);
    }

    public TypeConverterDelegate(PropertyEditorRegistrySupport propertyEditorRegistry, Object targetObject) {
        this.propertyEditorRegistry = propertyEditorRegistry;
        this.targetObject = targetObject;
    }

    public <T> T convertIfNecessary(Object newValue, Class<T> requiredType) throws IllegalArgumentException {
        return this.convertIfNecessary(null, null, newValue, requiredType, null, null);
    }

    public <T> T convertIfNecessary(Object newValue, Class<T> requiredType, MethodParameter methodParam) throws IllegalArgumentException {
        return this.convertIfNecessary(null, null, newValue, requiredType, null, methodParam);
    }

    public <T> T convertIfNecessary(String propertyName, Object oldValue, Object newValue, Class<T> requiredType) throws IllegalArgumentException {
        return this.convertIfNecessary(propertyName, oldValue, newValue, requiredType, null, null);
    }

    public Object convertIfNecessary(Object oldValue, Object newValue, PropertyDescriptor descriptor) throws IllegalArgumentException {
        return this.convertIfNecessary(descriptor.getName(), oldValue, newValue, descriptor.getPropertyType(), descriptor, BeanUtils.getWriteMethodParameter(descriptor));
    }

    protected <T> T convertIfNecessary(String propertyName, Object oldValue, Object newValue, Class<T> requiredType, PropertyDescriptor descriptor, MethodParameter methodParam) throws IllegalArgumentException {
        TypeDescriptor targetTypeDesc;
        TypeDescriptor sourceTypeDesc;
        Object convertedValue = newValue;
        PropertyEditor editor = this.propertyEditorRegistry.findCustomEditor(requiredType, propertyName);
        ConversionService conversionService = this.propertyEditorRegistry.getConversionService();
        if (editor == null && conversionService != null && convertedValue != null && conversionService.canConvert(sourceTypeDesc = TypeDescriptor.valueOf(convertedValue.getClass()), targetTypeDesc = methodParam != null ? (descriptor != null ? new BeanTypeDescriptor(methodParam, descriptor) : new TypeDescriptor(methodParam)) : TypeDescriptor.valueOf(requiredType))) {
            return (T)conversionService.convert(convertedValue, sourceTypeDesc, targetTypeDesc);
        }
        if (editor != null || requiredType != null && !ClassUtils.isAssignableValue(requiredType, (Object)convertedValue)) {
            if (editor == null) {
                editor = this.findDefaultEditor(requiredType, descriptor);
            }
            convertedValue = this.doConvertValue(oldValue, convertedValue, requiredType, editor);
        }
        if (requiredType != null) {
            if (convertedValue != null) {
                if (String.class.equals(requiredType) && ClassUtils.isPrimitiveOrWrapper(convertedValue.getClass())) {
                    return (T)convertedValue.toString();
                }
                if (requiredType.isArray()) {
                    return (T)this.convertToTypedArray(convertedValue, propertyName, requiredType.getComponentType());
                }
                if (convertedValue instanceof Collection) {
                    convertedValue = this.convertToTypedCollection((Collection)convertedValue, propertyName, requiredType, methodParam);
                } else if (convertedValue instanceof Map) {
                    convertedValue = this.convertToTypedMap((Map)convertedValue, propertyName, requiredType, methodParam);
                } else if (convertedValue instanceof String && !requiredType.isInstance(convertedValue)) {
                    block21: {
                        if (!requiredType.isInterface() && !requiredType.isEnum()) {
                            try {
                                Constructor<T> strCtor = requiredType.getConstructor(String.class);
                                return BeanUtils.instantiateClass(strCtor, convertedValue);
                            }
                            catch (NoSuchMethodException ex) {
                                if (logger.isTraceEnabled()) {
                                    logger.trace((Object)("No String constructor found on type [" + requiredType.getName() + "]"), (Throwable)ex);
                                }
                            }
                            catch (Exception ex) {
                                if (!logger.isDebugEnabled()) break block21;
                                logger.debug((Object)("Construction via String failed for type [" + requiredType.getName() + "]"), (Throwable)ex);
                            }
                        }
                    }
                    String trimmedValue = ((String)convertedValue).trim();
                    if (requiredType.isEnum() && "".equals(trimmedValue)) {
                        return null;
                    }
                    convertedValue = this.attemptToConvertStringToEnum(requiredType, trimmedValue, convertedValue);
                }
            }
            if (!ClassUtils.isAssignableValue(requiredType, (Object)convertedValue)) {
                StringBuilder msg = new StringBuilder();
                msg.append("Cannot convert value of type [").append(ClassUtils.getDescriptiveType((Object)newValue));
                msg.append("] to required type [").append(ClassUtils.getQualifiedName(requiredType)).append("]");
                if (propertyName != null) {
                    msg.append(" for property '").append(propertyName).append("'");
                }
                if (editor != null) {
                    msg.append(": PropertyEditor [").append(editor.getClass().getName()).append("] returned inappropriate value");
                    throw new IllegalArgumentException(msg.toString());
                }
                msg.append(": no matching editors or conversion strategy found");
                throw new IllegalStateException(msg.toString());
            }
        }
        return (T)convertedValue;
    }

    private Object attemptToConvertStringToEnum(Class<?> requiredType, String trimmedValue, Object currentConvertedValue) {
        Object convertedValue;
        block9: {
            block8: {
                int index;
                convertedValue = currentConvertedValue;
                if (Enum.class.equals(requiredType) && (index = trimmedValue.lastIndexOf(".")) > -1) {
                    String enumType = trimmedValue.substring(0, index);
                    String fieldName = trimmedValue.substring(index + 1);
                    ClassLoader loader = this.targetObject.getClass().getClassLoader();
                    try {
                        Class<?> enumValueType = loader.loadClass(enumType);
                        Field enumField = enumValueType.getField(fieldName);
                        convertedValue = enumField.get(null);
                    }
                    catch (ClassNotFoundException ex) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Enum class [" + enumType + "] cannot be loaded from [" + loader + "]"), (Throwable)ex);
                        }
                    }
                    catch (Throwable ex) {
                        if (!logger.isTraceEnabled()) break block8;
                        logger.trace((Object)("Field [" + fieldName + "] isn't an enum value for type [" + enumType + "]"), ex);
                    }
                }
            }
            if (convertedValue == currentConvertedValue) {
                try {
                    Field enumField = requiredType.getField(trimmedValue);
                    convertedValue = enumField.get(null);
                }
                catch (Throwable ex) {
                    if (!logger.isTraceEnabled()) break block9;
                    logger.trace((Object)("Field [" + convertedValue + "] isn't an enum value"), ex);
                }
            }
        }
        return convertedValue;
    }

    protected PropertyEditor findDefaultEditor(Class requiredType, PropertyDescriptor descriptor) {
        PropertyEditor editor = null;
        if (descriptor != null) {
            editor = descriptor.createPropertyEditor(this.targetObject);
        }
        if (editor == null && requiredType != null && (editor = this.propertyEditorRegistry.getDefaultEditor(requiredType)) == null && !String.class.equals((Object)requiredType)) {
            editor = BeanUtils.findEditorByConvention(requiredType);
        }
        return editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doConvertValue(Object oldValue, Object newValue, Class<?> requiredType, PropertyEditor editor) {
        boolean sharedEditor;
        Object convertedValue;
        block20: {
            convertedValue = newValue;
            sharedEditor = false;
            if (editor != null) {
                sharedEditor = this.propertyEditorRegistry.isSharedEditor(editor);
            }
            if (editor != null && !(convertedValue instanceof String)) {
                try {
                    Object newConvertedValue;
                    if (sharedEditor) {
                        PropertyEditor propertyEditor = editor;
                        synchronized (propertyEditor) {
                            editor.setValue(convertedValue);
                            newConvertedValue = editor.getValue();
                        }
                    } else {
                        editor.setValue(convertedValue);
                        newConvertedValue = editor.getValue();
                    }
                    if (newConvertedValue != convertedValue) {
                        convertedValue = newConvertedValue;
                        editor = null;
                    }
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block20;
                    logger.debug((Object)("PropertyEditor [" + editor.getClass().getName() + "] does not support setValue call"), (Throwable)ex);
                }
            }
        }
        Object returnValue = convertedValue;
        if (requiredType != null && !requiredType.isArray() && convertedValue instanceof String[]) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Converting String array to comma-delimited String [" + convertedValue + "]"));
            }
            convertedValue = StringUtils.arrayToCommaDelimitedString((Object[])((String[])convertedValue));
        }
        if (convertedValue instanceof String) {
            if (editor != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Converting String to [" + requiredType + "] using property editor [" + editor + "]"));
                }
                String newTextValue = (String)convertedValue;
                if (sharedEditor) {
                    PropertyEditor propertyEditor = editor;
                    synchronized (propertyEditor) {
                        return this.doConvertTextValue(oldValue, newTextValue, editor);
                    }
                }
                return this.doConvertTextValue(oldValue, newTextValue, editor);
            }
            if (String.class.equals(requiredType)) {
                returnValue = convertedValue;
            }
        }
        return returnValue;
    }

    protected Object doConvertTextValue(Object oldValue, String newTextValue, PropertyEditor editor) {
        block2: {
            try {
                editor.setValue(oldValue);
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)("PropertyEditor [" + editor.getClass().getName() + "] does not support setValue call"), (Throwable)ex);
            }
        }
        editor.setAsText(newTextValue);
        return editor.getValue();
    }

    protected Object convertToTypedArray(Object input, String propertyName, Class<?> componentType) {
        if (input instanceof Collection) {
            Collection coll = (Collection)input;
            Object result = Array.newInstance(componentType, coll.size());
            int i = 0;
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                Object value = this.convertIfNecessary(this.buildIndexedPropertyName(propertyName, i), null, it.next(), componentType);
                Array.set(result, i, value);
                ++i;
            }
            return result;
        }
        if (input.getClass().isArray()) {
            if (componentType.equals(input.getClass().getComponentType()) && !this.propertyEditorRegistry.hasCustomEditorForElement(componentType, propertyName)) {
                return input;
            }
            int arrayLength = Array.getLength(input);
            Object result = Array.newInstance(componentType, arrayLength);
            int i = 0;
            while (i < arrayLength) {
                Object value = this.convertIfNecessary(this.buildIndexedPropertyName(propertyName, i), null, Array.get(input, i), componentType);
                Array.set(result, i, value);
                ++i;
            }
            return result;
        }
        Object result = Array.newInstance(componentType, 1);
        Object value = this.convertIfNecessary(this.buildIndexedPropertyName(propertyName, 0), null, input, componentType);
        Array.set(result, 0, value);
        return result;
    }

    protected Collection convertToTypedCollection(Collection original, String propertyName, Class requiredType, MethodParameter methodParam) {
        Collection convertedCopy;
        Iterator it;
        boolean originalAllowed = requiredType.isInstance(original);
        Class elementType = null;
        if (methodParam != null) {
            elementType = GenericCollectionTypeResolver.getCollectionParameterType((MethodParameter)methodParam);
        }
        if (elementType == null && originalAllowed && !this.propertyEditorRegistry.hasCustomEditorForElement(null, propertyName)) {
            return original;
        }
        try {
            it = original.iterator();
            if (it == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Collection of type [" + original.getClass().getName() + "] returned null Iterator - injecting original Collection as-is"));
                }
                return original;
            }
        }
        catch (Throwable ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cannot access Collection of type [" + original.getClass().getName() + "] - injecting original Collection as-is"), ex);
            }
            return original;
        }
        try {
            convertedCopy = CollectionFactory.isApproximableCollectionType((Class)requiredType) ? CollectionFactory.createApproximateCollection((Object)original, (int)original.size()) : (Collection)requiredType.newInstance();
        }
        catch (Throwable ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cannot create copy of Collection type [" + original.getClass().getName() + "] - injecting original Collection as-is"), ex);
            }
            return original;
        }
        int i = 0;
        while (it.hasNext()) {
            Object element = it.next();
            String indexedPropertyName = this.buildIndexedPropertyName(propertyName, i);
            if (methodParam != null) {
                methodParam.increaseNestingLevel();
            }
            Object convertedElement = this.convertIfNecessary(indexedPropertyName, null, element, elementType, null, methodParam);
            if (methodParam != null) {
                methodParam.decreaseNestingLevel();
            }
            convertedCopy.add(convertedElement);
            originalAllowed = originalAllowed && element == convertedElement;
            ++i;
        }
        return originalAllowed ? original : convertedCopy;
    }

    /*
     * Unable to fully structure code
     */
    protected Map convertToTypedMap(Map original, String propertyName, Class requiredType, MethodParameter methodParam) {
        originalAllowed = requiredType.isInstance(original);
        keyType = null;
        valueType = null;
        if (methodParam != null) {
            keyType = GenericCollectionTypeResolver.getMapKeyParameterType((MethodParameter)methodParam);
            valueType = GenericCollectionTypeResolver.getMapValueParameterType((MethodParameter)methodParam);
        }
        if (keyType == null && valueType == null && originalAllowed && !this.propertyEditorRegistry.hasCustomEditorForElement(null, propertyName)) {
            return original;
        }
        try {
            it = original.entrySet().iterator();
            if (it == null) {
                if (TypeConverterDelegate.logger.isDebugEnabled()) {
                    TypeConverterDelegate.logger.debug((Object)("Map of type [" + original.getClass().getName() + "] returned null Iterator - injecting original Map as-is"));
                }
                return original;
            }
        }
        catch (Throwable ex) {
            if (TypeConverterDelegate.logger.isDebugEnabled()) {
                TypeConverterDelegate.logger.debug((Object)("Cannot access Map of type [" + original.getClass().getName() + "] - injecting original Map as-is"), ex);
            }
            return original;
        }
        try {
            block14: {
                if (!CollectionFactory.isApproximableMapType((Class)requiredType)) break block14;
                convertedCopy = CollectionFactory.createApproximateMap((Object)original, (int)original.size());
                ** GOTO lbl48
            }
            convertedCopy = (Map)requiredType.newInstance();
            if (true) ** GOTO lbl48
        }
        catch (Throwable ex) {
            if (TypeConverterDelegate.logger.isDebugEnabled()) {
                TypeConverterDelegate.logger.debug((Object)("Cannot create copy of Map type [" + original.getClass().getName() + "] - injecting original Map as-is"), ex);
            }
            return original;
        }
        do {
            entry = it.next();
            key = entry.getKey();
            value = entry.getValue();
            keyedPropertyName = this.buildKeyedPropertyName(propertyName, key);
            if (methodParam != null) {
                methodParam.increaseNestingLevel();
                methodParam.setTypeIndexForCurrentLevel(0);
            }
            convertedKey = this.convertIfNecessary(keyedPropertyName, null, key, keyType, null, methodParam);
            if (methodParam != null) {
                methodParam.setTypeIndexForCurrentLevel(1);
            }
            convertedValue = this.convertIfNecessary(keyedPropertyName, null, value, valueType, null, methodParam);
            if (methodParam != null) {
                methodParam.decreaseNestingLevel();
            }
            convertedCopy.put(convertedKey, convertedValue);
            v0 = originalAllowed = originalAllowed != false && key == convertedKey && value == convertedValue;
lbl48:
            // 3 sources

        } while (it.hasNext());
        return originalAllowed != false ? original : convertedCopy;
    }

    private String buildIndexedPropertyName(String propertyName, int index) {
        return propertyName != null ? String.valueOf(propertyName) + "[" + index + "]" : null;
    }

    private String buildKeyedPropertyName(String propertyName, Object key) {
        return propertyName != null ? String.valueOf(propertyName) + "[" + key + "]" : null;
    }
}

