/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.method;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.support.DefaultConversionService;
import org.springframework.binding.method.MethodInvocationException;
import org.springframework.binding.method.MethodKey;
import org.springframework.binding.method.MethodSignature;
import org.springframework.binding.method.Parameter;
import org.springframework.binding.method.Parameters;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.CachingMapDecorator;

public class MethodInvoker {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$binding$method$MethodInvoker == null ? (class$org$springframework$binding$method$MethodInvoker = MethodInvoker.class$("org.springframework.binding.method.MethodInvoker")) : class$org$springframework$binding$method$MethodInvoker));
    private ConversionService conversionService = new DefaultConversionService();
    private CachingMapDecorator methodCache = new CachingMapDecorator(true){

        public Object create(Object key) {
            return ((MethodKey)key).getMethod();
        }
    };
    static /* synthetic */ Class class$org$springframework$binding$method$MethodInvoker;

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Object invoke(MethodSignature signature, Object bean, Object argumentSource) throws MethodInvocationException {
        Object argument;
        Parameters parameters = signature.getParameters();
        Object[] arguments = new Object[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = parameters.getParameter(i);
            argument = parameter.evaluateArgument(argumentSource, null);
            arguments[i] = this.applyTypeConversion(argument, parameter.getType());
        }
        Class[] parameterTypes = parameters.getTypesArray();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] != null || (argument = arguments[i]) == null) continue;
            parameterTypes[i] = argument.getClass();
        }
        MethodKey key = new MethodKey(bean.getClass(), signature.getMethodName(), parameterTypes);
        try {
            Method method = (Method)this.methodCache.get((Object)key);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking method with signature [" + key + "] with arguments " + StylerUtils.style((Object)arguments) + " on bean [" + bean + "]"));
            }
            Object returnValue = method.invoke(bean, arguments);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoked method with signature [" + key + "] returned value [" + returnValue + "]"));
            }
            return returnValue;
        }
        catch (Exception e) {
            throw new MethodInvocationException(signature, arguments, e);
        }
    }

    protected Object applyTypeConversion(Object parameterValue, Class targetType) {
        if (parameterValue == null || targetType == null) {
            return parameterValue;
        }
        return this.conversionService.getConversionExecutor(parameterValue.getClass(), targetType).execute(parameterValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

