/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.index.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Completion;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.springframework.context.index.processor.CandidateComponentsMetadata;
import org.springframework.context.index.processor.IndexedStereotypesProvider;
import org.springframework.context.index.processor.ItemMetadata;
import org.springframework.context.index.processor.MetadataCollector;
import org.springframework.context.index.processor.MetadataStore;
import org.springframework.context.index.processor.PackageInfoStereotypesProvider;
import org.springframework.context.index.processor.StandardStereotypesProvider;
import org.springframework.context.index.processor.StereotypesProvider;
import org.springframework.context.index.processor.TypeHelper;

public class CandidateComponentsIndexer
implements Processor {
    private static final Set<ElementKind> TYPE_KINDS = Collections.unmodifiableSet(EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE));
    private MetadataStore metadataStore;
    private MetadataCollector metadataCollector;
    private TypeHelper typeHelper;
    private List<StereotypesProvider> stereotypesProviders;

    @Override
    public Set<String> getSupportedOptions() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("*");
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        this.stereotypesProviders = this.getStereotypesProviders(env);
        this.typeHelper = new TypeHelper(env);
        this.metadataStore = new MetadataStore(env);
        this.metadataCollector = new MetadataCollector(env, this.metadataStore.readMetadata());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.metadataCollector.processing(roundEnv);
        roundEnv.getRootElements().forEach(this::processElement);
        if (roundEnv.processingOver()) {
            this.writeMetaData();
        }
        return false;
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        return Collections.emptyList();
    }

    private List<StereotypesProvider> getStereotypesProviders(ProcessingEnvironment env) {
        ArrayList<StereotypesProvider> result = new ArrayList<StereotypesProvider>();
        TypeHelper typeHelper = new TypeHelper(env);
        result.add(new IndexedStereotypesProvider(typeHelper));
        result.add(new StandardStereotypesProvider(typeHelper));
        result.add(new PackageInfoStereotypesProvider());
        return result;
    }

    private void processElement(Element element) {
        this.addMetadataFor(element);
        CandidateComponentsIndexer.staticTypesIn(element.getEnclosedElements()).forEach(this::processElement);
    }

    private void addMetadataFor(Element element) {
        LinkedHashSet<String> stereotypes = new LinkedHashSet<String>();
        this.stereotypesProviders.forEach(p -> stereotypes.addAll(p.getStereotypes(element)));
        if (!stereotypes.isEmpty()) {
            this.metadataCollector.add(new ItemMetadata(this.typeHelper.getType(element), stereotypes));
        }
    }

    private void writeMetaData() {
        CandidateComponentsMetadata metadata = this.metadataCollector.getMetadata();
        if (!metadata.getItems().isEmpty()) {
            try {
                this.metadataStore.writeMetadata(metadata);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failed to write metadata", ex);
            }
        }
    }

    private static List<TypeElement> staticTypesIn(Iterable<? extends Element> elements) {
        ArrayList<TypeElement> list = new ArrayList<TypeElement>();
        for (Element element : elements) {
            if (!TYPE_KINDS.contains((Object)element.getKind()) || !element.getModifiers().contains((Object)Modifier.STATIC)) continue;
            list.add((TypeElement)element);
        }
        return list;
    }
}

