/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.annotation;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.cache.annotation.CacheAnnotationParser;
import org.springframework.cache.annotation.SpringCachingAnnotationParser;
import org.springframework.cache.interceptor.AbstractFallbackCacheDefinitionSource;
import org.springframework.cache.interceptor.CacheDefinition;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationCacheDefinitionSource
extends AbstractFallbackCacheDefinitionSource
implements Serializable {
    private final boolean publicMethodsOnly;
    private final Set<CacheAnnotationParser> annotationParsers;

    public AnnotationCacheDefinitionSource() {
        this(true);
    }

    public AnnotationCacheDefinitionSource(boolean publicMethodsOnly) {
        this.publicMethodsOnly = publicMethodsOnly;
        this.annotationParsers = new LinkedHashSet<CacheAnnotationParser>(1);
        this.annotationParsers.add(new SpringCachingAnnotationParser());
    }

    public AnnotationCacheDefinitionSource(CacheAnnotationParser ... annotationParsers) {
        this.publicMethodsOnly = true;
        Assert.notEmpty((Object[])annotationParsers, (String)"At least one CacheAnnotationParser needs to be specified");
        LinkedHashSet<CacheAnnotationParser> parsers = new LinkedHashSet<CacheAnnotationParser>(annotationParsers.length);
        Collections.addAll(parsers, annotationParsers);
        this.annotationParsers = parsers;
    }

    @Override
    protected CacheDefinition findCacheDefinition(Class<?> clazz) {
        return this.determineCacheDefinition(clazz);
    }

    @Override
    protected CacheDefinition findCacheOperation(Method method) {
        return this.determineCacheDefinition(method);
    }

    protected CacheDefinition determineCacheDefinition(AnnotatedElement ae) {
        for (CacheAnnotationParser annotationParser : this.annotationParsers) {
            CacheDefinition attr = annotationParser.parseCacheAnnotation(ae);
            if (attr == null) continue;
            return attr;
        }
        return null;
    }

    @Override
    protected boolean allowPublicMethodsOnly() {
        return this.publicMethodsOnly;
    }
}

