/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.support;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCacheManager
implements CacheManager,
InitializingBean {
    private final ConcurrentMap<String, Cache<?, ?>> caches = new ConcurrentHashMap();
    private Collection<String> names;

    public void afterPropertiesSet() {
        Collection<Cache<?, ?>> cacheSet = this.loadCaches();
        Assert.notEmpty(cacheSet);
        this.caches.clear();
        LinkedHashSet<String> cacheNames = new LinkedHashSet<String>(cacheSet.size());
        for (Cache<?, ?> cache : cacheSet) {
            this.caches.put(cache.getName(), cache);
            cacheNames.add(cache.getName());
        }
        this.names = Collections.unmodifiableSet(cacheNames);
    }

    protected abstract Collection<Cache<?, ?>> loadCaches();

    protected final ConcurrentMap<String, Cache<?, ?>> getCacheMap() {
        return this.caches;
    }

    @Override
    public <K, V> Cache<K, V> getCache(String name) {
        return (Cache)this.caches.get(name);
    }

    @Override
    public Collection<String> getCacheNames() {
        return this.names;
    }
}

