/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.config;

import org.springframework.context.config.FeatureSpecification;
import org.springframework.context.config.FeatureSpecificationExecutor;
import org.springframework.context.config.SpecificationContext;
import org.springframework.core.GenericTypeResolver;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSpecificationExecutor<S extends FeatureSpecification>
implements FeatureSpecificationExecutor {
    @Override
    public final void execute(FeatureSpecification spec, SpecificationContext specificationContext) {
        Assert.notNull((Object)spec, (String)"Specification must not be null");
        Assert.notNull((Object)spec, (String)"SpecificationContext must not be null");
        Class typeArg = GenericTypeResolver.resolveTypeArgument(this.getClass(), AbstractSpecificationExecutor.class);
        Assert.isTrue((boolean)typeArg.equals(spec.getClass()), (String)"Specification cannot be executed by this executor");
        if (spec.validate(specificationContext.getProblemReporter())) {
            this.doExecute(spec, specificationContext);
        }
    }

    protected abstract void doExecute(S var1, SpecificationContext var2);
}

