/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CacheOperationSource;
import org.springframework.cache.interceptor.CacheUpdateOperation;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFallbackCacheOperationSource
implements CacheOperationSource {
    private static final CacheOperation NULL_CACHING_ATTRIBUTE = new CacheUpdateOperation();
    protected final Log logger = LogFactory.getLog(this.getClass());
    final Map<Object, CacheOperation> attributeCache = new ConcurrentHashMap<Object, CacheOperation>();

    @Override
    public CacheOperation getCacheOperation(Method method, Class<?> targetClass) {
        Object cacheKey = this.getCacheKey(method, targetClass);
        CacheOperation cached = this.attributeCache.get(cacheKey);
        if (cached != null) {
            if (cached == NULL_CACHING_ATTRIBUTE) {
                return null;
            }
            return cached;
        }
        CacheOperation cacheDef = this.computeCacheOperationDefinition(method, targetClass);
        if (cacheDef == null) {
            this.attributeCache.put(cacheKey, NULL_CACHING_ATTRIBUTE);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Adding cacheable method '" + method.getName() + "' with attribute: " + cacheDef));
            }
            this.attributeCache.put(cacheKey, cacheDef);
        }
        return cacheDef;
    }

    protected Object getCacheKey(Method method, Class<?> targetClass) {
        return new DefaultCacheKey(method, targetClass);
    }

    private CacheOperation computeCacheOperationDefinition(Method method, Class<?> targetClass) {
        if (this.allowPublicMethodsOnly() && !Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, targetClass);
        CacheOperation opDef = this.findCacheOperation(specificMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod));
        if (opDef != null) {
            return opDef;
        }
        opDef = this.findCacheOperation(specificMethod.getDeclaringClass());
        if (opDef != null) {
            return opDef;
        }
        if (specificMethod != method) {
            opDef = this.findCacheOperation(method);
            if (opDef != null) {
                return opDef;
            }
            return this.findCacheOperation(method.getDeclaringClass());
        }
        return null;
    }

    protected abstract CacheOperation findCacheOperation(Method var1);

    protected abstract CacheOperation findCacheOperation(Class<?> var1);

    protected boolean allowPublicMethodsOnly() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultCacheKey {
        private final Method method;
        private final Class<?> targetClass;

        public DefaultCacheKey(Method method, Class<?> targetClass) {
            this.method = method;
            this.targetClass = targetClass;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DefaultCacheKey)) {
                return false;
            }
            DefaultCacheKey otherKey = (DefaultCacheKey)other;
            return this.method.equals(otherKey.method) && ObjectUtils.nullSafeEquals(this.targetClass, otherKey.targetClass);
        }

        public int hashCode() {
            return this.method.hashCode() * 29 + (this.targetClass != null ? this.targetClass.hashCode() : 0);
        }
    }
}

