/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.CacheEvictOperation;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CacheOperationSource;
import org.springframework.cache.interceptor.CacheUpdateOperation;
import org.springframework.cache.interceptor.CompositeCacheOperationSource;
import org.springframework.cache.interceptor.DefaultKeyGenerator;
import org.springframework.cache.interceptor.ExpressionEvaluator;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.expression.EvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CacheAspectSupport
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private CacheManager cacheManager;
    private CacheOperationSource cacheOperationSource;
    private final ExpressionEvaluator evaluator = new ExpressionEvaluator();
    private KeyGenerator keyGenerator = new DefaultKeyGenerator();
    private boolean initialized = false;

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheOperationSources(CacheOperationSource ... cacheDefinitionSources) {
        Assert.notEmpty((Object[])cacheDefinitionSources);
        this.cacheOperationSource = cacheDefinitionSources.length > 1 ? new CompositeCacheOperationSource(cacheDefinitionSources) : cacheDefinitionSources[0];
    }

    public void setCacheOperationSource(CacheOperationSource cacheOperationSource) {
        this.cacheOperationSource = cacheOperationSource;
    }

    public CacheOperationSource getCacheOperationSource() {
        return this.cacheOperationSource;
    }

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    public void afterPropertiesSet() {
        if (this.cacheManager == null) {
            throw new IllegalStateException("'cacheManager' is required");
        }
        if (this.cacheOperationSource == null) {
            throw new IllegalStateException("Either 'cacheDefinitionSource' or 'cacheDefinitionSources' is required: If there are no cacheable methods, then don't use a cache aspect.");
        }
        this.initialized = true;
    }

    protected String methodIdentification(Method method, Class<?> targetClass) {
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, targetClass);
        return ClassUtils.getQualifiedMethodName((Method)specificMethod);
    }

    protected Collection<Cache> getCaches(CacheOperation operation) {
        Set<String> cacheNames = operation.getCacheNames();
        ArrayList<Cache> caches = new ArrayList<Cache>(cacheNames.size());
        for (String cacheName : cacheNames) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null) {
                throw new IllegalArgumentException("Cannot find cache named [" + cacheName + "] for " + operation);
            }
            caches.add(cache);
        }
        return caches;
    }

    protected CacheOperationContext getOperationContext(CacheOperation operation, Method method, Object[] args, Object target, Class<?> targetClass) {
        return new CacheOperationContext(operation, method, args, target, targetClass);
    }

    protected Object execute(Invoker invoker, Object target, Method method, Object[] args) {
        if (!this.initialized) {
            return invoker.invoke();
        }
        boolean log = this.logger.isTraceEnabled();
        Class<?> targetClass = AopProxyUtils.ultimateTargetClass((Object)target);
        if (targetClass == null && target != null) {
            targetClass = target.getClass();
        }
        CacheOperation cacheOp = this.getCacheOperationSource().getCacheOperation(method, targetClass);
        Object retVal = null;
        if (cacheOp != null) {
            CacheOperationContext context = this.getOperationContext(cacheOp, method, args, target, targetClass);
            Collection<Cache> caches = context.getCaches();
            if (context.hasConditionPassed()) {
                if (cacheOp instanceof CacheUpdateOperation) {
                    Object key = context.generateKey();
                    if (log) {
                        this.logger.trace((Object)("Computed cache key " + key + " for definition " + cacheOp));
                    }
                    if (key == null) {
                        throw new IllegalArgumentException("Null key returned for cache definition (maybe you are using named params on classes without debug info?) " + cacheOp);
                    }
                    boolean cacheHit = false;
                    Iterator<Cache> iterator = caches.iterator();
                    while (iterator.hasNext() && !cacheHit) {
                        Cache cache = iterator.next();
                        Cache.ValueWrapper wrapper = cache.get(key);
                        if (wrapper == null) continue;
                        cacheHit = true;
                        retVal = wrapper.get();
                    }
                    if (!cacheHit) {
                        if (log) {
                            this.logger.trace((Object)("Key " + key + " NOT found in cache(s), invoking cached target method  " + method));
                        }
                        retVal = invoker.invoke();
                        for (Cache cache : caches) {
                            cache.put(key, retVal);
                        }
                    } else if (log) {
                        this.logger.trace((Object)("Key " + key + " found in cache, returning value " + retVal));
                    }
                }
                if (cacheOp instanceof CacheEvictOperation) {
                    CacheEvictOperation evictOp = (CacheEvictOperation)cacheOp;
                    Object key = null;
                    for (Cache cache : caches) {
                        if (evictOp.isCacheWide()) {
                            cache.clear();
                            if (!log) continue;
                            this.logger.trace((Object)("Invalidating entire cache for definition " + cacheOp + " on method " + method));
                            continue;
                        }
                        if (key == null) {
                            key = context.generateKey();
                        }
                        if (log) {
                            this.logger.trace((Object)("Invalidating cache key " + key + " for definition " + cacheOp + " on method " + method));
                        }
                        cache.evict(key);
                    }
                    retVal = invoker.invoke();
                }
                return retVal;
            }
            if (log) {
                this.logger.trace((Object)("Cache condition failed on method " + method + " for definition " + cacheOp));
            }
        }
        return invoker.invoke();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CacheOperationContext {
        private final CacheOperation operation;
        private final Collection<Cache> caches;
        private final Object target;
        private final Method method;
        private final Object[] args;
        private final EvaluationContext evalContext;

        public CacheOperationContext(CacheOperation operation, Method method, Object[] args, Object target, Class<?> targetClass) {
            this.operation = operation;
            this.caches = CacheAspectSupport.this.getCaches(operation);
            this.target = target;
            this.method = method;
            this.args = args;
            this.evalContext = CacheAspectSupport.this.evaluator.createEvaluationContext(this.caches, method, args, target, targetClass);
        }

        protected boolean hasConditionPassed() {
            if (StringUtils.hasText((String)this.operation.getCondition())) {
                return CacheAspectSupport.this.evaluator.condition(this.operation.getCondition(), this.method, this.evalContext);
            }
            return true;
        }

        protected Object generateKey() {
            if (StringUtils.hasText((String)this.operation.getKey())) {
                return CacheAspectSupport.this.evaluator.key(this.operation.getKey(), this.method, this.evalContext);
            }
            return CacheAspectSupport.this.keyGenerator.extract(this.target, this.method, this.args);
        }

        protected Collection<Cache> getCaches() {
            return this.caches;
        }
    }

    public static interface Invoker {
        public Object invoke();
    }
}

