/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.annotation.ScheduledAnnotationReactiveSupport;
import org.springframework.scheduling.annotation.Schedules;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.CronTask;
import org.springframework.scheduling.config.FixedDelayTask;
import org.springframework.scheduling.config.FixedRateTask;
import org.springframework.scheduling.config.OneTimeTask;
import org.springframework.scheduling.config.ScheduledTask;
import org.springframework.scheduling.config.ScheduledTaskHolder;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.config.TaskSchedulerRouter;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.ScheduledMethodRunnable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class ScheduledAnnotationBeanPostProcessor
implements ScheduledTaskHolder,
MergedBeanDefinitionPostProcessor,
DestructionAwareBeanPostProcessor,
Ordered,
EmbeddedValueResolverAware,
BeanNameAware,
BeanFactoryAware,
ApplicationContextAware,
SmartInitializingSingleton,
DisposableBean,
ApplicationListener<ApplicationContextEvent> {
    public static final String DEFAULT_TASK_SCHEDULER_BEAN_NAME = "taskScheduler";
    private static final boolean reactiveStreamsPresent = ClassUtils.isPresent((String)"org.reactivestreams.Publisher", (ClassLoader)ScheduledAnnotationBeanPostProcessor.class.getClassLoader());
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ScheduledTaskRegistrar registrar;
    @Nullable
    private Object scheduler;
    @Nullable
    private StringValueResolver embeddedValueResolver;
    @Nullable
    private String beanName;
    @Nullable
    private BeanFactory beanFactory;
    @Nullable
    private ApplicationContext applicationContext;
    @Nullable
    private TaskSchedulerRouter localScheduler;
    private final Set<Class<?>> nonAnnotatedClasses = ConcurrentHashMap.newKeySet(64);
    private final Map<Object, Set<ScheduledTask>> scheduledTasks = new IdentityHashMap<Object, Set<ScheduledTask>>(16);
    private final Map<Object, List<Runnable>> reactiveSubscriptions = new IdentityHashMap<Object, List<Runnable>>(16);
    private final Set<Object> manualCancellationOnContextClose = Collections.newSetFromMap(new IdentityHashMap(16));

    public ScheduledAnnotationBeanPostProcessor() {
        this.registrar = new ScheduledTaskRegistrar();
    }

    public ScheduledAnnotationBeanPostProcessor(ScheduledTaskRegistrar registrar) {
        Assert.notNull((Object)registrar, (String)"ScheduledTaskRegistrar must not be null");
        this.registrar = registrar;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setScheduler(Object scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        if (this.beanFactory == null) {
            this.beanFactory = applicationContext;
        }
    }

    public void afterSingletonsInstantiated() {
        this.nonAnnotatedClasses.clear();
        if (this.applicationContext == null) {
            this.finishRegistration();
        }
    }

    private void finishRegistration() {
        if (this.scheduler != null) {
            this.registrar.setScheduler(this.scheduler);
        } else {
            this.localScheduler = new TaskSchedulerRouter();
            this.localScheduler.setBeanName(this.beanName);
            this.localScheduler.setBeanFactory(this.beanFactory);
            this.registrar.setTaskScheduler(this.localScheduler);
        }
        BeanFactory beanFactory = this.beanFactory;
        if (beanFactory instanceof ListableBeanFactory) {
            ListableBeanFactory lbf = (ListableBeanFactory)beanFactory;
            Map beans2 = lbf.getBeansOfType(SchedulingConfigurer.class);
            ArrayList configurers = new ArrayList(beans2.values());
            AnnotationAwareOrderComparator.sort(configurers);
            for (SchedulingConfigurer configurer : configurers) {
                configurer.configureTasks(this.registrar);
            }
        }
        this.registrar.afterPropertiesSet();
    }

    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
    }

    public Object postProcessBeforeInitialization(Object bean2, String beanName) {
        return bean2;
    }

    public Object postProcessAfterInitialization(Object bean2, String beanName) {
        if (bean2 instanceof AopInfrastructureBean || bean2 instanceof TaskScheduler || bean2 instanceof ScheduledExecutorService) {
            return bean2;
        }
        Class targetClass = AopProxyUtils.ultimateTargetClass((Object)bean2);
        if (!this.nonAnnotatedClasses.contains(targetClass) && AnnotationUtils.isCandidateClass((Class)targetClass, List.of(Scheduled.class, Schedules.class))) {
            Map annotatedMethods = MethodIntrospector.selectMethods((Class)targetClass, method -> {
                Set scheduledAnnotations = AnnotatedElementUtils.getMergedRepeatableAnnotations((AnnotatedElement)method, Scheduled.class, Schedules.class);
                return !scheduledAnnotations.isEmpty() ? scheduledAnnotations : null;
            });
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(targetClass);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("No @Scheduled annotations found on bean class: " + targetClass));
                }
            } else {
                SingletonBeanRegistry sbr;
                BeanFactory beanFactory;
                annotatedMethods.forEach((method, scheduledAnnotations) -> scheduledAnnotations.forEach(scheduled -> this.processScheduled((Scheduled)scheduled, (Method)method, bean2)));
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)(annotatedMethods.size() + " @Scheduled methods processed on bean '" + beanName + "': " + annotatedMethods));
                }
                if (this.beanFactory != null && !this.beanFactory.isSingleton(beanName) || (beanFactory = this.beanFactory) instanceof SingletonBeanRegistry && (sbr = (SingletonBeanRegistry)beanFactory).containsSingleton(beanName)) {
                    this.manualCancellationOnContextClose.add(bean2);
                }
            }
        }
        return bean2;
    }

    protected void processScheduled(Scheduled scheduled, Method method, Object bean2) {
        if (reactiveStreamsPresent && ScheduledAnnotationReactiveSupport.isReactive(method)) {
            this.processScheduledAsync(scheduled, method, bean2);
            return;
        }
        this.processScheduledSync(scheduled, method, bean2);
    }

    private void processScheduledSync(Scheduled scheduled, Method method, Object bean2) {
        Runnable task;
        try {
            task = this.createRunnable(bean2, method, scheduled.scheduler());
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException("Could not create recurring task for @Scheduled method '" + method.getName() + "': " + ex.getMessage());
        }
        this.processScheduledTask(scheduled, task, method, bean2);
    }

    private void processScheduledAsync(Scheduled scheduled, Method method, Object bean2) {
        Runnable task;
        try {
            task = ScheduledAnnotationReactiveSupport.createSubscriptionRunnable(method, bean2, scheduled, this.registrar::getObservationRegistry, this.reactiveSubscriptions.computeIfAbsent(bean2, k -> new CopyOnWriteArrayList()));
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException("Could not create recurring task for @Scheduled method '" + method.getName() + "': " + ex.getMessage());
        }
        this.processScheduledTask(scheduled, task, method, bean2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processScheduledTask(Scheduled scheduled, Runnable runnable, Method method, Object bean2) {
        try {
            String fixedRateString;
            Duration fixedRate;
            String fixedDelayString;
            String cron;
            boolean processedSchedule = false;
            String errorMessage = "Exactly one of the 'cron', 'fixedDelay' or 'fixedRate' attributes is required";
            LinkedHashSet<ScheduledTask> tasks = new LinkedHashSet<ScheduledTask>(4);
            Duration initialDelay = ScheduledAnnotationBeanPostProcessor.toDuration(scheduled.initialDelay(), scheduled.timeUnit());
            String initialDelayString = scheduled.initialDelayString();
            if (StringUtils.hasText((String)initialDelayString)) {
                Assert.isTrue((boolean)initialDelay.isNegative(), (String)"Specify 'initialDelay' or 'initialDelayString', not both");
                if (this.embeddedValueResolver != null) {
                    initialDelayString = this.embeddedValueResolver.resolveStringValue(initialDelayString);
                }
                if (StringUtils.hasLength((String)initialDelayString)) {
                    try {
                        initialDelay = ScheduledAnnotationBeanPostProcessor.toDuration(initialDelayString, scheduled.timeUnit());
                    }
                    catch (RuntimeException ex) {
                        throw new IllegalArgumentException("Invalid initialDelayString value \"" + initialDelayString + "\"; " + ex);
                    }
                }
            }
            if (StringUtils.hasText((String)(cron = scheduled.cron()))) {
                String zone = scheduled.zone();
                if (this.embeddedValueResolver != null) {
                    cron = this.embeddedValueResolver.resolveStringValue(cron);
                    zone = this.embeddedValueResolver.resolveStringValue(zone);
                }
                if (StringUtils.hasLength((String)cron)) {
                    Assert.isTrue((boolean)initialDelay.isNegative(), (String)"'initialDelay' not supported for cron triggers");
                    processedSchedule = true;
                    if (!"-".equals(cron)) {
                        CronTrigger trigger = StringUtils.hasText((String)zone) ? new CronTrigger(cron, StringUtils.parseTimeZoneString((String)zone)) : new CronTrigger(cron);
                        tasks.add(this.registrar.scheduleCronTask(new CronTask(runnable, trigger)));
                    }
                }
            }
            Duration delayToUse = initialDelay.isNegative() ? Duration.ZERO : initialDelay;
            Duration fixedDelay = ScheduledAnnotationBeanPostProcessor.toDuration(scheduled.fixedDelay(), scheduled.timeUnit());
            if (!fixedDelay.isNegative()) {
                Assert.isTrue((!processedSchedule ? 1 : 0) != 0, (String)errorMessage);
                processedSchedule = true;
                tasks.add(this.registrar.scheduleFixedDelayTask(new FixedDelayTask(runnable, fixedDelay, delayToUse)));
            }
            if (StringUtils.hasText((String)(fixedDelayString = scheduled.fixedDelayString()))) {
                if (this.embeddedValueResolver != null) {
                    fixedDelayString = this.embeddedValueResolver.resolveStringValue(fixedDelayString);
                }
                if (StringUtils.hasLength((String)fixedDelayString)) {
                    Assert.isTrue((!processedSchedule ? 1 : 0) != 0, (String)errorMessage);
                    processedSchedule = true;
                    try {
                        fixedDelay = ScheduledAnnotationBeanPostProcessor.toDuration(fixedDelayString, scheduled.timeUnit());
                    }
                    catch (RuntimeException ex) {
                        throw new IllegalArgumentException("Invalid fixedDelayString value \"" + fixedDelayString + "\"; " + ex);
                    }
                    tasks.add(this.registrar.scheduleFixedDelayTask(new FixedDelayTask(runnable, fixedDelay, delayToUse)));
                }
            }
            if (!(fixedRate = ScheduledAnnotationBeanPostProcessor.toDuration(scheduled.fixedRate(), scheduled.timeUnit())).isNegative()) {
                Assert.isTrue((!processedSchedule ? 1 : 0) != 0, (String)errorMessage);
                processedSchedule = true;
                tasks.add(this.registrar.scheduleFixedRateTask(new FixedRateTask(runnable, fixedRate, delayToUse)));
            }
            if (StringUtils.hasText((String)(fixedRateString = scheduled.fixedRateString()))) {
                if (this.embeddedValueResolver != null) {
                    fixedRateString = this.embeddedValueResolver.resolveStringValue(fixedRateString);
                }
                if (StringUtils.hasLength((String)fixedRateString)) {
                    Assert.isTrue((!processedSchedule ? 1 : 0) != 0, (String)errorMessage);
                    processedSchedule = true;
                    try {
                        fixedRate = ScheduledAnnotationBeanPostProcessor.toDuration(fixedRateString, scheduled.timeUnit());
                    }
                    catch (RuntimeException ex) {
                        throw new IllegalArgumentException("Invalid fixedRateString value \"" + fixedRateString + "\"; " + ex);
                    }
                    tasks.add(this.registrar.scheduleFixedRateTask(new FixedRateTask(runnable, fixedRate, delayToUse)));
                }
            }
            if (!processedSchedule) {
                if (initialDelay.isNegative()) {
                    throw new IllegalArgumentException("One-time task only supported with specified initial delay");
                }
                tasks.add(this.registrar.scheduleOneTimeTask(new OneTimeTask(runnable, delayToUse)));
            }
            Map<Object, Set<ScheduledTask>> map = this.scheduledTasks;
            synchronized (map) {
                Set regTasks = this.scheduledTasks.computeIfAbsent(bean2, key -> new LinkedHashSet(4));
                regTasks.addAll(tasks);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException("Encountered invalid @Scheduled method '" + method.getName() + "': " + ex.getMessage());
        }
    }

    protected Runnable createRunnable(Object target, Method method, @Nullable String qualifier) {
        Runnable runnable = this.createRunnable(target, method);
        if (runnable != null) {
            return runnable;
        }
        Assert.isTrue((method.getParameterCount() == 0 ? 1 : 0) != 0, (String)"Only no-arg methods may be annotated with @Scheduled");
        Method invocableMethod = AopUtils.selectInvocableMethod((Method)method, target.getClass());
        return new ScheduledMethodRunnable(target, invocableMethod, qualifier, this.registrar::getObservationRegistry);
    }

    @Deprecated(since="6.1")
    @Nullable
    protected Runnable createRunnable(Object target, Method method) {
        return null;
    }

    private static Duration toDuration(long value, TimeUnit timeUnit) {
        try {
            return Duration.of(value, timeUnit.toChronoUnit());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unsupported unit " + timeUnit + " for value \"" + value + "\": " + ex.getMessage());
        }
    }

    private static Duration toDuration(String value, TimeUnit timeUnit) {
        if (ScheduledAnnotationBeanPostProcessor.isDurationString(value)) {
            return Duration.parse(value);
        }
        return ScheduledAnnotationBeanPostProcessor.toDuration(Long.parseLong(value), timeUnit);
    }

    private static boolean isDurationString(String value) {
        return value.length() > 1 && (ScheduledAnnotationBeanPostProcessor.isP(value.charAt(0)) || ScheduledAnnotationBeanPostProcessor.isP(value.charAt(1)));
    }

    private static boolean isP(char ch) {
        return ch == 'P' || ch == 'p';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ScheduledTask> getScheduledTasks() {
        LinkedHashSet<ScheduledTask> result = new LinkedHashSet<ScheduledTask>();
        Map<Object, Set<ScheduledTask>> map = this.scheduledTasks;
        synchronized (map) {
            Collection<Set<ScheduledTask>> allTasks = this.scheduledTasks.values();
            for (Set<ScheduledTask> tasks : allTasks) {
                result.addAll(tasks);
            }
        }
        result.addAll(this.registrar.getScheduledTasks());
        return result;
    }

    public void postProcessBeforeDestruction(Object bean2, String beanName) {
        this.cancelScheduledTasks(bean2);
        this.manualCancellationOnContextClose.remove(bean2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requiresDestruction(Object bean2) {
        Map<Object, Set<ScheduledTask>> map = this.scheduledTasks;
        synchronized (map) {
            return this.scheduledTasks.containsKey(bean2) || this.reactiveSubscriptions.containsKey(bean2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelScheduledTasks(Object bean2) {
        List<Runnable> liveSubscriptions;
        Set<ScheduledTask> tasks;
        Iterator<Runnable> iterator = this.scheduledTasks;
        synchronized (iterator) {
            tasks = this.scheduledTasks.remove(bean2);
            liveSubscriptions = this.reactiveSubscriptions.remove(bean2);
        }
        if (tasks != null) {
            for (ScheduledTask task : tasks) {
                task.cancel(false);
            }
        }
        if (liveSubscriptions != null) {
            for (Runnable subscription : liveSubscriptions) {
                subscription.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Map<Object, Set<ScheduledTask>> map = this.scheduledTasks;
        synchronized (map) {
            Collection<Set<ScheduledTask>> allTasks = this.scheduledTasks.values();
            for (Set<ScheduledTask> tasks : allTasks) {
                for (ScheduledTask task : tasks) {
                    task.cancel(false);
                }
            }
            this.scheduledTasks.clear();
            Collection<List<Runnable>> allLiveSubscriptions = this.reactiveSubscriptions.values();
            for (List<Runnable> liveSubscriptions : allLiveSubscriptions) {
                for (Runnable liveSubscription : liveSubscriptions) {
                    liveSubscription.run();
                }
            }
            this.reactiveSubscriptions.clear();
            this.manualCancellationOnContextClose.clear();
        }
        this.registrar.destroy();
        if (this.localScheduler != null) {
            this.localScheduler.destroy();
        }
    }

    @Override
    public void onApplicationEvent(ApplicationContextEvent event) {
        if (event.getApplicationContext() == this.applicationContext) {
            if (event instanceof ContextRefreshedEvent) {
                this.finishRegistration();
            } else if (event instanceof ContextClosedEvent) {
                for (Object bean2 : this.manualCancellationOnContextClose) {
                    this.cancelScheduledTasks(bean2);
                }
                this.manualCancellationOnContextClose.clear();
            }
        }
    }
}

