/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.Query;
import net.sf.hibernate.ReplicationMode;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.type.Type;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.orm.hibernate.HibernateAccessor;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.HibernateOperations;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.util.Assert;

public class HibernateTemplate
extends HibernateAccessor
implements HibernateOperations {
    private boolean allowCreate = true;
    private boolean alwaysUseNewSession = false;
    private boolean exposeNativeSession = false;
    private boolean checkWriteOperations = true;
    private boolean cacheQueries = false;
    private String queryCacheRegion;
    private int fetchSize = 0;
    private int maxResults = 0;
    static /* synthetic */ Class class$net$sf$hibernate$Session;

    public HibernateTemplate() {
    }

    public HibernateTemplate(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
        this.afterPropertiesSet();
    }

    public HibernateTemplate(SessionFactory sessionFactory, boolean allowCreate) {
        this.setSessionFactory(sessionFactory);
        this.setAllowCreate(allowCreate);
        this.afterPropertiesSet();
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public void setAlwaysUseNewSession(boolean alwaysUseNewSession) {
        this.alwaysUseNewSession = alwaysUseNewSession;
    }

    public boolean isAlwaysUseNewSession() {
        return this.alwaysUseNewSession;
    }

    public void setExposeNativeSession(boolean exposeNativeSession) {
        this.exposeNativeSession = exposeNativeSession;
    }

    public boolean isExposeNativeSession() {
        return this.exposeNativeSession;
    }

    public void setCheckWriteOperations(boolean checkWriteOperations) {
        this.checkWriteOperations = checkWriteOperations;
    }

    public boolean isCheckWriteOperations() {
        return this.checkWriteOperations;
    }

    public void setCacheQueries(boolean cacheQueries) {
        this.cacheQueries = cacheQueries;
    }

    public boolean isCacheQueries() {
        return this.cacheQueries;
    }

    public void setQueryCacheRegion(String queryCacheRegion) {
        this.queryCacheRegion = queryCacheRegion;
    }

    public String getQueryCacheRegion() {
        return this.queryCacheRegion;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public Object execute(HibernateCallback action) throws DataAccessException {
        return this.execute(action, this.isExposeNativeSession());
    }

    public List executeFind(HibernateCallback action) throws DataAccessException {
        Object result = this.execute(action, this.isExposeNativeSession());
        if (result != null && !(result instanceof List)) {
            throw new InvalidDataAccessApiUsageException("Result object returned from HibernateCallback isn't a List: [" + result + "]");
        }
        return (List)result;
    }

    public Object execute(HibernateCallback action, boolean exposeNativeSession) throws DataAccessException {
        Assert.notNull((Object)action, (String)"Callback object must not be null");
        Session session = this.getSession();
        boolean existingTransaction = SessionFactoryUtils.isSessionTransactional(session, this.getSessionFactory());
        if (existingTransaction) {
            this.logger.debug((Object)"Found thread-bound Session for HibernateTemplate");
        }
        FlushMode previousFlushMode = null;
        try {
            previousFlushMode = this.applyFlushMode(session, existingTransaction);
            Session sessionToExpose = exposeNativeSession ? session : this.createSessionProxy(session);
            Object result = action.doInHibernate(sessionToExpose);
            this.flushIfNecessary(session, existingTransaction);
            Object object = result;
            return object;
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        catch (SQLException ex) {
            throw this.convertJdbcAccessException(ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            if (existingTransaction) {
                this.logger.debug((Object)"Not closing pre-bound Hibernate Session after HibernateTemplate");
                if (previousFlushMode != null) {
                    session.setFlushMode(previousFlushMode);
                }
            } else if (this.isAlwaysUseNewSession()) {
                SessionFactoryUtils.closeSession(session);
            } else {
                SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.getSessionFactory());
            }
        }
    }

    protected Session getSession() {
        if (this.isAlwaysUseNewSession()) {
            return SessionFactoryUtils.getNewSession(this.getSessionFactory(), this.getEntityInterceptor());
        }
        if (!this.isAllowCreate()) {
            return SessionFactoryUtils.getSession(this.getSessionFactory(), false);
        }
        return SessionFactoryUtils.getSession(this.getSessionFactory(), this.getEntityInterceptor(), this.getJdbcExceptionTranslator());
    }

    protected Session createSessionProxy(Session session) {
        return (Session)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$net$sf$hibernate$Session == null ? (class$net$sf$hibernate$Session = HibernateTemplate.class$("net.sf.hibernate.Session")) : class$net$sf$hibernate$Session}, (InvocationHandler)new CloseSuppressingInvocationHandler(session));
    }

    public Object get(Class entityClass, Serializable id) throws DataAccessException {
        return this.get(entityClass, id, null);
    }

    public Object get(final Class entityClass, final Serializable id, final LockMode lockMode) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (lockMode != null) {
                    return session.get(entityClass, id, lockMode);
                }
                return session.get(entityClass, id);
            }
        }, true);
    }

    public Object load(Class entityClass, Serializable id) throws DataAccessException {
        return this.load(entityClass, id, null);
    }

    public Object load(final Class entityClass, final Serializable id, final LockMode lockMode) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (lockMode != null) {
                    return session.load(entityClass, id, lockMode);
                }
                return session.load(entityClass, id);
            }
        }, true);
    }

    public List loadAll(final Class entityClass) throws DataAccessException {
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(entityClass);
                HibernateTemplate.this.prepareCriteria(criteria);
                return criteria.list();
            }
        }, true);
    }

    public void load(final Object entity, final Serializable id) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.load(entity, id);
                return null;
            }
        }, true);
    }

    public void refresh(Object entity) throws DataAccessException {
        this.refresh(entity, null);
    }

    public void refresh(final Object entity, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (lockMode != null) {
                    session.refresh(entity, lockMode);
                } else {
                    session.refresh(entity);
                }
                return null;
            }
        }, true);
    }

    public boolean contains(final Object entity) throws DataAccessException {
        Boolean result = (Boolean)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                return session.contains(entity) ? Boolean.TRUE : Boolean.FALSE;
            }
        }, true);
        return result;
    }

    public void evict(final Object entity) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.evict(entity);
                return null;
            }
        }, true);
    }

    public void initialize(Object proxy) throws DataAccessException {
        try {
            Hibernate.initialize((Object)proxy);
        }
        catch (HibernateException ex) {
            throw SessionFactoryUtils.convertHibernateAccessException(ex);
        }
    }

    public void lock(final Object entity, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.lock(entity, lockMode);
                return null;
            }
        }, true);
    }

    public Serializable save(final Object entity) throws DataAccessException {
        return (Serializable)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                return session.save(entity);
            }
        }, true);
    }

    public void save(final Object entity, final Serializable id) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.save(entity, id);
                return null;
            }
        }, true);
    }

    public void update(Object entity) throws DataAccessException {
        this.update(entity, null);
    }

    public void update(final Object entity, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.update(entity);
                if (lockMode != null) {
                    session.lock(entity, lockMode);
                }
                return null;
            }
        }, true);
    }

    public void saveOrUpdate(final Object entity) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.saveOrUpdate(entity);
                return null;
            }
        }, true);
    }

    public void saveOrUpdateAll(final Collection entities) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                Iterator it = entities.iterator();
                while (it.hasNext()) {
                    session.saveOrUpdate(it.next());
                }
                return null;
            }
        }, true);
    }

    public Object saveOrUpdateCopy(final Object entity) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                return session.saveOrUpdateCopy(entity);
            }
        }, true);
    }

    public void replicate(final Object entity, final ReplicationMode replicationMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.replicate(entity, replicationMode);
                return null;
            }
        }, true);
    }

    public void delete(Object entity) throws DataAccessException {
        this.delete(entity, null);
    }

    public void delete(final Object entity, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                if (lockMode != null) {
                    session.lock(entity, lockMode);
                }
                session.delete(entity);
                return null;
            }
        }, true);
    }

    public void deleteAll(final Collection entities) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                Iterator it = entities.iterator();
                while (it.hasNext()) {
                    session.delete(it.next());
                }
                return null;
            }
        }, true);
    }

    public void flush() throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.flush();
                return null;
            }
        }, true);
    }

    public void clear() throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                session.clear();
                return null;
            }
        }, true);
    }

    public List find(String queryString) throws DataAccessException {
        return this.find(queryString, null, (Type[])null);
    }

    public List find(String queryString, Object value) throws DataAccessException {
        return this.find(queryString, new Object[]{value}, (Type[])null);
    }

    public List find(String queryString, Object value, Type type) throws DataAccessException {
        return this.find(queryString, new Object[]{value}, new Type[]{type});
    }

    public List find(String queryString, Object[] values) throws DataAccessException {
        return this.find(queryString, values, (Type[])null);
    }

    public List find(final String queryString, final Object[] values, final Type[] types) throws DataAccessException {
        if (values != null && types != null && values.length != types.length) {
            throw new IllegalArgumentException("Length of values array must match length of types array");
        }
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(queryString);
                HibernateTemplate.this.prepareQuery(queryObject);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        if (types != null && types[i] != null) {
                            queryObject.setParameter(i, values[i], types[i]);
                            continue;
                        }
                        queryObject.setParameter(i, values[i]);
                    }
                }
                return queryObject.list();
            }
        }, true);
    }

    public List findByNamedParam(String queryString, String paramName, Object value) throws DataAccessException {
        return this.findByNamedParam(queryString, paramName, value, null);
    }

    public List findByNamedParam(String queryString, String paramName, Object value, Type type) throws DataAccessException {
        return this.findByNamedParam(queryString, new String[]{paramName}, new Object[]{value}, new Type[]{type});
    }

    public List findByNamedParam(String queryString, String[] paramNames, Object[] values) throws DataAccessException {
        return this.findByNamedParam(queryString, paramNames, values, null);
    }

    public List findByNamedParam(final String queryString, final String[] paramNames, final Object[] values, final Type[] types) throws DataAccessException {
        if (paramNames.length != values.length) {
            throw new IllegalArgumentException("Length of paramNames array must match length of values array");
        }
        if (types != null && paramNames.length != types.length) {
            throw new IllegalArgumentException("Length of paramNames array must match length of types array");
        }
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(queryString);
                HibernateTemplate.this.prepareQuery(queryObject);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        HibernateTemplate.this.applyNamedParameterToQuery(queryObject, paramNames[i], values[i], types != null ? types[i] : null);
                    }
                }
                return queryObject.list();
            }
        }, true);
    }

    public List findByValueBean(final String queryString, final Object valueBean) throws DataAccessException {
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(queryString);
                HibernateTemplate.this.prepareQuery(queryObject);
                queryObject.setProperties(valueBean);
                return queryObject.list();
            }
        }, true);
    }

    public List findByNamedQuery(String queryName) throws DataAccessException {
        return this.findByNamedQuery(queryName, null, (Type[])null);
    }

    public List findByNamedQuery(String queryName, Object value) throws DataAccessException {
        return this.findByNamedQuery(queryName, new Object[]{value}, (Type[])null);
    }

    public List findByNamedQuery(String queryName, Object value, Type type) throws DataAccessException {
        return this.findByNamedQuery(queryName, new Object[]{value}, new Type[]{type});
    }

    public List findByNamedQuery(String queryName, Object[] values) throws DataAccessException {
        return this.findByNamedQuery(queryName, values, (Type[])null);
    }

    public List findByNamedQuery(final String queryName, final Object[] values, final Type[] types) throws DataAccessException {
        if (values != null && types != null && values.length != types.length) {
            throw new IllegalArgumentException("Length of values array must match length of types array");
        }
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery(queryName);
                HibernateTemplate.this.prepareQuery(queryObject);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        if (types != null && types[i] != null) {
                            queryObject.setParameter(i, values[i], types[i]);
                            continue;
                        }
                        queryObject.setParameter(i, values[i]);
                    }
                }
                return queryObject.list();
            }
        }, true);
    }

    public List findByNamedQueryAndNamedParam(String queryName, String paramName, Object value) throws DataAccessException {
        return this.findByNamedQueryAndNamedParam(queryName, paramName, value, null);
    }

    public List findByNamedQueryAndNamedParam(String queryName, String paramName, Object value, Type type) throws DataAccessException {
        return this.findByNamedQueryAndNamedParam(queryName, new String[]{paramName}, new Object[]{value}, new Type[]{type});
    }

    public List findByNamedQueryAndNamedParam(String queryName, String[] paramNames, Object[] values) throws DataAccessException {
        return this.findByNamedQueryAndNamedParam(queryName, paramNames, values, null);
    }

    public List findByNamedQueryAndNamedParam(final String queryName, final String[] paramNames, final Object[] values, final Type[] types) throws DataAccessException {
        if (paramNames != null && values != null && paramNames.length != values.length) {
            throw new IllegalArgumentException("Length of paramNames array must match length of values array");
        }
        if (values != null && types != null && paramNames.length != types.length) {
            throw new IllegalArgumentException("Length of paramNames array must match length of types array");
        }
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery(queryName);
                HibernateTemplate.this.prepareQuery(queryObject);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        HibernateTemplate.this.applyNamedParameterToQuery(queryObject, paramNames[i], values[i], types != null ? types[i] : null);
                    }
                }
                return queryObject.list();
            }
        }, true);
    }

    public List findByNamedQueryAndValueBean(final String queryName, final Object valueBean) throws DataAccessException {
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery(queryName);
                HibernateTemplate.this.prepareQuery(queryObject);
                queryObject.setProperties(valueBean);
                return queryObject.list();
            }
        }, true);
    }

    public Iterator iterate(String queryString) throws DataAccessException {
        return this.iterate(queryString, null, (Type[])null);
    }

    public Iterator iterate(String queryString, Object value) throws DataAccessException {
        return this.iterate(queryString, new Object[]{value}, (Type[])null);
    }

    public Iterator iterate(String queryString, Object value, Type type) throws DataAccessException {
        return this.iterate(queryString, new Object[]{value}, new Type[]{type});
    }

    public Iterator iterate(String queryString, Object[] values) throws DataAccessException {
        return this.iterate(queryString, values, (Type[])null);
    }

    public Iterator iterate(final String queryString, final Object[] values, final Type[] types) throws DataAccessException {
        if (values != null && types != null && values.length != types.length) {
            throw new IllegalArgumentException("Length of values array must match length of types array");
        }
        return (Iterator)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(queryString);
                HibernateTemplate.this.prepareQuery(queryObject);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        if (types != null && types[i] != null) {
                            queryObject.setParameter(i, values[i], types[i]);
                            continue;
                        }
                        queryObject.setParameter(i, values[i]);
                    }
                }
                return queryObject.iterate();
            }
        }, true);
    }

    public void closeIterator(Iterator it) throws DataAccessException {
        try {
            Hibernate.close((Iterator)it);
        }
        catch (HibernateException ex) {
            throw SessionFactoryUtils.convertHibernateAccessException(ex);
        }
    }

    public int delete(String queryString) throws DataAccessException {
        return this.delete(queryString, null, (Type[])null);
    }

    public int delete(String queryString, Object value, Type type) throws DataAccessException {
        return this.delete(queryString, new Object[]{value}, new Type[]{type});
    }

    public int delete(final String queryString, final Object[] values, final Type[] types) throws DataAccessException {
        if (values != null && types != null && values.length != types.length) {
            throw new IllegalArgumentException("Length of values array must match length of types array");
        }
        Integer deleteCount = (Integer)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                if (values != null) {
                    return new Integer(session.delete(queryString, values, types));
                }
                return new Integer(session.delete(queryString));
            }
        }, true);
        return deleteCount;
    }

    protected void checkWriteOperationAllowed(Session session) throws InvalidDataAccessApiUsageException {
        if (this.isCheckWriteOperations() && this.getFlushMode() != 2 && FlushMode.NEVER.equals(session.getFlushMode())) {
            throw new InvalidDataAccessApiUsageException("Write operations are not allowed in read-only mode (FlushMode.NEVER): Turn your Session into FlushMode.AUTO or remove 'readOnly' marker from transaction definition.");
        }
    }

    protected void prepareQuery(Query queryObject) {
        if (this.isCacheQueries()) {
            queryObject.setCacheable(true);
            if (this.getQueryCacheRegion() != null) {
                queryObject.setCacheRegion(this.getQueryCacheRegion());
            }
        }
        if (this.getFetchSize() > 0) {
            queryObject.setFetchSize(this.getFetchSize());
        }
        if (this.getMaxResults() > 0) {
            queryObject.setMaxResults(this.getMaxResults());
        }
        SessionFactoryUtils.applyTransactionTimeout(queryObject, this.getSessionFactory());
    }

    protected void prepareCriteria(Criteria criteria) {
        if (this.isCacheQueries()) {
            criteria.setCacheable(true);
            if (this.getQueryCacheRegion() != null) {
                criteria.setCacheRegion(this.getQueryCacheRegion());
            }
        }
        if (this.getFetchSize() > 0) {
            criteria.setFetchSize(this.getFetchSize());
        }
        if (this.getMaxResults() > 0) {
            criteria.setMaxResults(this.getMaxResults());
        }
        SessionFactoryUtils.applyTransactionTimeout(criteria, this.getSessionFactory());
    }

    protected void applyNamedParameterToQuery(Query queryObject, String paramName, Object value, Type type) throws HibernateException {
        if (value instanceof Collection) {
            if (type != null) {
                queryObject.setParameterList(paramName, (Collection)value, type);
            } else {
                queryObject.setParameterList(paramName, (Collection)value);
            }
        } else if (value instanceof Object[]) {
            if (type != null) {
                queryObject.setParameterList(paramName, (Object[])value, type);
            } else {
                queryObject.setParameterList(paramName, (Object[])value);
            }
        } else if (type != null) {
            queryObject.setParameter(paramName, value, type);
        } else {
            queryObject.setParameter(paramName, value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Session target;

        public CloseSuppressingInvocationHandler(Session target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                if (retVal instanceof Query) {
                    HibernateTemplate.this.prepareQuery((Query)retVal);
                }
                if (retVal instanceof Criteria) {
                    HibernateTemplate.this.prepareCriteria((Criteria)retVal);
                }
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

