/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler;

import java.lang.reflect.Method;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.annotation.AnnotatedMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class HandlerMethod
extends AnnotatedMethod {
    public static final Log defaultLogger = LogFactory.getLog(HandlerMethod.class);
    private final Object bean;
    @Nullable
    private final BeanFactory beanFactory;
    private final Class<?> beanType;
    @Nullable
    private HandlerMethod resolvedFromHandlerMethod;
    protected Log logger = defaultLogger;

    public HandlerMethod(Object bean, Method method) {
        super(method);
        this.bean = bean;
        this.beanFactory = null;
        this.beanType = ClassUtils.getUserClass((Object)bean);
    }

    public HandlerMethod(Object bean, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        super(bean.getClass().getMethod(methodName, parameterTypes));
        this.bean = bean;
        this.beanFactory = null;
        this.beanType = ClassUtils.getUserClass((Object)bean);
    }

    public HandlerMethod(String beanName, BeanFactory beanFactory, Method method) {
        super(method);
        this.bean = beanName;
        this.beanFactory = beanFactory;
        Class beanType = beanFactory.getType(beanName);
        if (beanType == null) {
            throw new IllegalStateException("Cannot resolve bean type for bean with name '" + beanName + "'");
        }
        this.beanType = ClassUtils.getUserClass((Class)beanType);
    }

    protected HandlerMethod(HandlerMethod handlerMethod) {
        super((AnnotatedMethod)handlerMethod);
        this.bean = handlerMethod.bean;
        this.beanFactory = handlerMethod.beanFactory;
        this.beanType = handlerMethod.beanType;
        this.resolvedFromHandlerMethod = handlerMethod.resolvedFromHandlerMethod;
    }

    private HandlerMethod(HandlerMethod handlerMethod, Object handler) {
        super((AnnotatedMethod)handlerMethod);
        this.bean = handler;
        this.beanFactory = handlerMethod.beanFactory;
        this.beanType = handlerMethod.beanType;
        this.resolvedFromHandlerMethod = handlerMethod;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public Log getLogger() {
        return this.logger;
    }

    public Object getBean() {
        return this.bean;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    protected Class<?> getContainingClass() {
        return this.beanType;
    }

    @Nullable
    public HandlerMethod getResolvedFromHandlerMethod() {
        return this.resolvedFromHandlerMethod;
    }

    public HandlerMethod createWithResolvedBean() {
        Object handler = this.bean;
        Object object = this.bean;
        if (object instanceof String) {
            String beanName = (String)object;
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"Cannot resolve bean name without BeanFactory");
            handler = this.beanFactory.getBean(beanName);
        }
        return new HandlerMethod(this, handler);
    }

    public String getShortLogMessage() {
        return this.getBeanType().getSimpleName() + "#" + this.getMethod().getName() + "[" + this.getMethod().getParameterCount() + " args]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!super.equals(other)) return false;
        if (!(other instanceof HandlerMethod)) return false;
        HandlerMethod otherMethod = (HandlerMethod)((Object)other);
        if (!this.bean.equals(otherMethod.bean)) return false;
        return true;
    }

    public int hashCode() {
        return this.bean.hashCode() * 31 + super.hashCode();
    }

    protected void assertTargetBean(Method method, Object targetBean, Object[] args) {
        Class<?> targetBeanClass;
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        if (!methodDeclaringClass.isAssignableFrom(targetBeanClass = targetBean.getClass())) {
            String text = "The mapped handler method class '" + methodDeclaringClass.getName() + "' is not an instance of the actual endpoint bean class '" + targetBeanClass.getName() + "'. If the endpoint requires proxying (e.g. due to @Transactional), please use class-based proxying.";
            throw new IllegalStateException(this.formatInvokeError(text, args));
        }
    }

    protected String formatInvokeError(String text, Object[] args) {
        String formattedArgs = IntStream.range(0, args.length).mapToObj(i2 -> args[i2] != null ? "[" + i2 + "] [type=" + args[i2].getClass().getName() + "] [value=" + args[i2] + "]" : "[" + i2 + "] [null]").collect(Collectors.joining(",\n", " ", " "));
        return text + "\nEndpoint [" + this.getBeanType().getName() + "]\nMethod [" + this.getBridgedMethod().toGenericString() + "] with argument values:\n" + formattedArgs;
    }
}

