/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.vendor;

import jakarta.persistence.EntityManager;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.jpa.PersistenceProvider;
import org.jspecify.annotations.Nullable;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.orm.jpa.vendor.EclipseLinkJpaDialect;

public class EclipseLinkJpaVendorAdapter
extends AbstractJpaVendorAdapter {
    private final jakarta.persistence.spi.PersistenceProvider persistenceProvider = new PersistenceProvider();
    private final EclipseLinkJpaDialect jpaDialect = new EclipseLinkJpaDialect();

    @Override
    public jakarta.persistence.spi.PersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    public Map<String, Object> getJpaPropertyMap() {
        HashMap<String, Object> jpaProperties = new HashMap<String, Object>();
        if (this.getDatabasePlatform() != null) {
            jpaProperties.put("eclipselink.target-database", this.getDatabasePlatform());
        } else {
            String targetDatabase = this.determineTargetDatabaseName(this.getDatabase());
            if (targetDatabase != null) {
                jpaProperties.put("eclipselink.target-database", targetDatabase);
            }
        }
        if (this.isGenerateDdl()) {
            jpaProperties.put("eclipselink.ddl-generation", "create-tables");
            jpaProperties.put("eclipselink.ddl-generation.output-mode", "database");
        }
        if (this.isShowSql()) {
            jpaProperties.put("eclipselink.logging.level.sql", Level.FINE.toString());
            jpaProperties.put("eclipselink.logging.parameters", Boolean.TRUE.toString());
        }
        return jpaProperties;
    }

    protected @Nullable String determineTargetDatabaseName(Database database) {
        return switch (database) {
            case Database.DB2 -> "DB2";
            case Database.DERBY -> "Derby";
            case Database.HANA -> "HANA";
            case Database.HSQL -> "HSQL";
            case Database.INFORMIX -> "Informix";
            case Database.MYSQL -> "MySQL";
            case Database.ORACLE -> "Oracle";
            case Database.POSTGRESQL -> "PostgreSQL";
            case Database.SQL_SERVER -> "SQLServer";
            case Database.SYBASE -> "Sybase";
            default -> null;
        };
    }

    @Override
    public EclipseLinkJpaDialect getJpaDialect() {
        return this.jpaDialect;
    }

    @Override
    public Class<? extends EntityManager> getEntityManagerInterface() {
        return JpaEntityManager.class;
    }
}

