/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.web;

import org.springframework.beans.factory.groovy.GroovyBeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.test.context.web.GenericXmlWebContextLoader;
import org.springframework.test.context.web.WebMergedContextConfiguration;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class GenericGroovyXmlWebContextLoader
extends GenericXmlWebContextLoader {
    @Override
    protected void loadBeanDefinitions(GenericWebApplicationContext context, WebMergedContextConfiguration webMergedConfig) {
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)context);
        GroovyBeanDefinitionReader groovyReader = new GroovyBeanDefinitionReader((BeanDefinitionRegistry)context);
        for (String location : webMergedConfig.getLocations()) {
            if (StringUtils.endsWithIgnoreCase((String)location, (String)".xml")) {
                xmlReader.loadBeanDefinitions(location);
                continue;
            }
            groovyReader.loadBeanDefinitions(location);
        }
    }

    @Override
    protected String[] getResourceSuffixes() {
        return new String[]{super.getResourceSuffix(), "Context.groovy"};
    }

    @Override
    protected String getResourceSuffix() {
        throw new UnsupportedOperationException("GenericGroovyXmlWebContextLoader does not support the getResourceSuffix() method");
    }
}

