/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.result.PrintingResultHandler;
import org.springframework.util.CollectionUtils;

public abstract class MockMvcResultHandlers {
    public static ResultHandler print() {
        return new ConsolePrintingResultHandler();
    }

    private static class ConsolePrintingResultHandler
    extends PrintingResultHandler {
        public ConsolePrintingResultHandler() {
            super(new PrintingResultHandler.ResultValuePrinter(){

                @Override
                public void printHeading(String heading) {
                    System.out.println();
                    System.out.println(String.format("%20s:", heading));
                }

                @Override
                public void printValue(String label, Object value) {
                    if (value != null && value.getClass().isArray()) {
                        value = CollectionUtils.arrayToList((Object)value);
                    }
                    System.out.println(String.format("%20s = %s", label, value));
                }
            });
        }
    }
}

