/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class HttpMethod
implements Comparable<HttpMethod>,
Serializable {
    private static final long serialVersionUID = -70133475680645360L;
    public static final HttpMethod GET = new HttpMethod("GET");
    public static final HttpMethod HEAD = new HttpMethod("HEAD");
    public static final HttpMethod POST = new HttpMethod("POST");
    public static final HttpMethod PUT = new HttpMethod("PUT");
    public static final HttpMethod PATCH = new HttpMethod("PATCH");
    public static final HttpMethod DELETE = new HttpMethod("DELETE");
    public static final HttpMethod OPTIONS = new HttpMethod("OPTIONS");
    public static final HttpMethod TRACE = new HttpMethod("TRACE");
    private static final HttpMethod[] values = new HttpMethod[]{GET, HEAD, POST, PUT, PATCH, DELETE, OPTIONS, TRACE};
    private static final Map<String, HttpMethod> mappings = Arrays.stream(values).collect(Collectors.toUnmodifiableMap(HttpMethod::name, Function.identity()));
    private final String name;

    private HttpMethod(String name) {
        this.name = name;
    }

    public static HttpMethod[] values() {
        HttpMethod[] copy = new HttpMethod[values.length];
        System.arraycopy(values, 0, copy, 0, values.length);
        return copy;
    }

    public static HttpMethod valueOf(String method) {
        Assert.notNull((Object)method, (String)"Method must not be null");
        HttpMethod result = mappings.get(method);
        if (result != null) {
            return result;
        }
        return new HttpMethod(method);
    }

    @Nullable
    @Deprecated
    public static HttpMethod resolve(@Nullable String method) {
        return method != null ? HttpMethod.valueOf(method) : null;
    }

    public String name() {
        return this.name;
    }

    public boolean matches(String method) {
        return this.name().equals(method);
    }

    @Override
    public int compareTo(HttpMethod other) {
        return this.name.compareTo(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HttpMethod) {
            HttpMethod otherMethod = (HttpMethod)o;
            return this.name.equals(otherMethod.name);
        }
        return false;
    }

    public String toString() {
        return this.name;
    }
}

