/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.observation;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.observation.DefaultHttpRequestsObservationConvention;
import org.springframework.web.observation.HttpRequestsObservation;
import org.springframework.web.observation.HttpRequestsObservationContext;
import org.springframework.web.observation.HttpRequestsObservationConvention;

public class HttpRequestsObservationFilter
extends OncePerRequestFilter {
    public static final String CURRENT_OBSERVATION_CONTEXT_ATTRIBUTE = HttpRequestsObservationFilter.class.getName() + ".context";
    private static final HttpRequestsObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultHttpRequestsObservationConvention();
    private static final String CURRENT_OBSERVATION_ATTRIBUTE = HttpRequestsObservationFilter.class.getName() + ".observation";
    private final ObservationRegistry observationRegistry;
    private final HttpRequestsObservationConvention observationConvention;

    public HttpRequestsObservationFilter(ObservationRegistry observationRegistry) {
        this(observationRegistry, new DefaultHttpRequestsObservationConvention());
    }

    public HttpRequestsObservationFilter(ObservationRegistry observationRegistry, HttpRequestsObservationConvention observationConvention) {
        this.observationRegistry = observationRegistry;
        this.observationConvention = observationConvention;
    }

    public static Optional<HttpRequestsObservationContext> findObservationContext(HttpServletRequest request) {
        return Optional.ofNullable((HttpRequestsObservationContext)((Object)request.getAttribute(CURRENT_OBSERVATION_CONTEXT_ATTRIBUTE)));
    }

    @Override
    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Observation observation = this.createOrFetchObservation(request, response);
        try (Observation.Scope scope = observation.openScope();){
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception ex) {
            observation.error(this.unwrapServletException(ex)).stop();
            throw ex;
        }
        finally {
            if (!request.isAsyncStarted()) {
                Throwable error = this.fetchException(request);
                if (error != null) {
                    response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
                    observation.error(error);
                }
                observation.stop();
            }
        }
    }

    private Observation createOrFetchObservation(HttpServletRequest request, HttpServletResponse response) {
        Observation observation = (Observation)request.getAttribute(CURRENT_OBSERVATION_ATTRIBUTE);
        if (observation == null) {
            HttpRequestsObservationContext context = new HttpRequestsObservationContext(request, response);
            observation = HttpRequestsObservation.HTTP_REQUESTS.observation(this.observationConvention, DEFAULT_OBSERVATION_CONVENTION, (Observation.Context)context, this.observationRegistry).start();
            request.setAttribute(CURRENT_OBSERVATION_ATTRIBUTE, (Object)observation);
            request.setAttribute(CURRENT_OBSERVATION_CONTEXT_ATTRIBUTE, (Object)observation.getContext());
        }
        return observation;
    }

    private Throwable unwrapServletException(Throwable ex) {
        return ex instanceof ServletException ? ex.getCause() : ex;
    }

    @Nullable
    private Throwable fetchException(HttpServletRequest request) {
        return (Throwable)request.getAttribute("jakarta.servlet.error.exception");
    }
}

