/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.observation.reactive;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.observation.reactive.HttpRequestsObservation;
import org.springframework.web.observation.reactive.HttpRequestsObservationContext;
import org.springframework.web.observation.reactive.HttpRequestsObservationConvention;
import org.springframework.web.util.pattern.PathPattern;

public class DefaultHttpRequestsObservationConvention
implements HttpRequestsObservationConvention {
    private static final String DEFAULT_NAME = "http.server.requests";
    private static final KeyValue METHOD_UNKNOWN = KeyValue.of((KeyName)HttpRequestsObservation.LowCardinalityKeyNames.METHOD, (String)"UNKNOWN");
    private static final KeyValue STATUS_UNKNOWN = KeyValue.of((KeyName)HttpRequestsObservation.LowCardinalityKeyNames.STATUS, (String)"UNKNOWN");
    private static final KeyValue URI_UNKNOWN = KeyValue.of((KeyName)HttpRequestsObservation.LowCardinalityKeyNames.URI, (String)"UNKNOWN");
    private static final KeyValue URI_ROOT = KeyValue.of((KeyName)HttpRequestsObservation.LowCardinalityKeyNames.URI, (String)"root");
    private static final KeyValue URI_NOT_FOUND = KeyValue.of((KeyName)HttpRequestsObservation.LowCardinalityKeyNames.URI, (String)"NOT_FOUND");
    private static final KeyValue URI_REDIRECTION = KeyValue.of((KeyName)HttpRequestsObservation.LowCardinalityKeyNames.URI, (String)"REDIRECTION");
    private static final KeyValue EXCEPTION_NONE = KeyValue.of((KeyName)HttpRequestsObservation.LowCardinalityKeyNames.EXCEPTION, (String)"none");
    private static final KeyValue OUTCOME_UNKNOWN = KeyValue.of((KeyName)HttpRequestsObservation.LowCardinalityKeyNames.OUTCOME, (String)"UNKNOWN");
    private static final KeyValue URI_EXPANDED_UNKNOWN = KeyValue.of((KeyName)HttpRequestsObservation.HighCardinalityKeyNames.URI_EXPANDED, (String)"UNKNOWN");
    private final String name;

    public DefaultHttpRequestsObservationConvention() {
        this(DEFAULT_NAME);
    }

    public DefaultHttpRequestsObservationConvention(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public KeyValues getLowCardinalityKeyValues(HttpRequestsObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.method(context), this.uri(context), this.status(context), this.exception(context), this.outcome(context)});
    }

    public KeyValues getHighCardinalityKeyValues(HttpRequestsObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.uriExpanded(context)});
    }

    protected KeyValue method(HttpRequestsObservationContext context) {
        return context.getCarrier() != null ? KeyValue.of((KeyName)HttpRequestsObservation.LowCardinalityKeyNames.METHOD, (String)((ServerHttpRequest)context.getCarrier()).getMethod().name()) : METHOD_UNKNOWN;
    }

    protected KeyValue status(HttpRequestsObservationContext context) {
        return context.getResponse() != null ? KeyValue.of((KeyName)HttpRequestsObservation.LowCardinalityKeyNames.STATUS, (String)Integer.toString(((ServerHttpResponse)context.getResponse()).getStatusCode().value())) : STATUS_UNKNOWN;
    }

    protected KeyValue uri(HttpRequestsObservationContext context) {
        if (context.getCarrier() != null) {
            HttpStatus status;
            PathPattern pattern = context.getPathPattern();
            if (pattern != null) {
                if (pattern.toString().isEmpty()) {
                    return URI_ROOT;
                }
                return KeyValue.of((String)"uri", (String)pattern.toString());
            }
            if (context.getResponse() != null && (status = HttpStatus.resolve(((ServerHttpResponse)context.getResponse()).getStatusCode().value())) != null) {
                if (status.is3xxRedirection()) {
                    return URI_REDIRECTION;
                }
                if (status == HttpStatus.NOT_FOUND) {
                    return URI_NOT_FOUND;
                }
            }
        }
        return URI_UNKNOWN;
    }

    protected KeyValue exception(HttpRequestsObservationContext context) {
        return context.getError().map(throwable -> KeyValue.of((KeyName)HttpRequestsObservation.LowCardinalityKeyNames.EXCEPTION, (String)throwable.getClass().getSimpleName())).orElse(EXCEPTION_NONE);
    }

    protected KeyValue outcome(HttpRequestsObservationContext context) {
        HttpStatus status;
        if (context.isConnectionAborted()) {
            return OUTCOME_UNKNOWN;
        }
        if (context.getResponse() != null && (status = HttpStatus.resolve(((ServerHttpResponse)context.getResponse()).getStatusCode().value())) != null) {
            return KeyValue.of((KeyName)HttpRequestsObservation.LowCardinalityKeyNames.OUTCOME, (String)status.series().name());
        }
        return OUTCOME_UNKNOWN;
    }

    protected KeyValue uriExpanded(HttpRequestsObservationContext context) {
        if (context.getCarrier() != null) {
            String uriExpanded = ((ServerHttpRequest)context.getCarrier()).getPath().toString();
            return KeyValue.of((KeyName)HttpRequestsObservation.HighCardinalityKeyNames.URI_EXPANDED, (String)uriExpanded);
        }
        return URI_EXPANDED_UNKNOWN;
    }
}

