/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.client.util.OutputStreamRequestContent;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.client.AbstractStreamingClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.JettyClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.StreamUtils;

class JettyClientHttpRequest
extends AbstractStreamingClientHttpRequest {
    private final Request request;
    private final Duration timeOut;

    public JettyClientHttpRequest(Request request, Duration timeOut) {
        this.request = request;
        this.timeOut = timeOut;
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.request.getMethod());
    }

    @Override
    public URI getURI() {
        return this.request.getURI();
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers, @Nullable StreamingHttpOutputMessage.Body body) throws IOException {
        if (!headers.isEmpty()) {
            this.request.headers(httpFields -> headers.forEach((headerName, headerValues) -> {
                for (String headerValue : headerValues) {
                    httpFields.add(headerName, headerValue);
                }
            }));
        }
        String contentType = null;
        if (headers.getContentType() != null) {
            contentType = headers.getContentType().toString();
        }
        try {
            InputStreamResponseListener responseListener = new InputStreamResponseListener();
            if (body != null) {
                OutputStreamRequestContent requestContent = new OutputStreamRequestContent(contentType);
                this.request.body((Request.Content)requestContent).send((Response.CompleteListener)responseListener);
                try (OutputStream outputStream = requestContent.getOutputStream();){
                    body.writeTo(StreamUtils.nonClosing((OutputStream)outputStream));
                }
            } else {
                this.request.send((Response.CompleteListener)responseListener);
            }
            Response response = responseListener.get(TimeUnit.MILLISECONDS.convert(this.timeOut), TimeUnit.MILLISECONDS);
            return new JettyClientHttpResponse(response, responseListener.getInputStream());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IOException("Request was interrupted: " + ex.getMessage(), ex);
        }
        catch (ExecutionException | TimeoutException ex) {
            throw new IOException("Could not send request: " + ex.getMessage(), ex);
        }
    }
}

