/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.JettyClientHttpRequest;
import org.springframework.util.Assert;

public class JettyClientHttpRequestFactory
implements ClientHttpRequestFactory,
InitializingBean,
DisposableBean {
    private final HttpClient httpClient;
    private final boolean defaultClient;
    private Duration timeOut = Duration.ofSeconds(1L);

    public JettyClientHttpRequestFactory() {
        this(new HttpClient(), true);
    }

    public JettyClientHttpRequestFactory(HttpClient httpClient) {
        this(httpClient, false);
    }

    private JettyClientHttpRequestFactory(HttpClient httpClient, boolean defaultClient) {
        this.httpClient = httpClient;
        this.defaultClient = defaultClient;
    }

    public void setTimeOut(Duration timeOut) {
        Assert.notNull((Object)timeOut, (String)"TimeOut must not be null");
        Assert.isTrue((!timeOut.isNegative() ? 1 : 0) != 0, (String)"TimeOut must not be negative");
        this.timeOut = timeOut;
    }

    public void afterPropertiesSet() throws Exception {
        this.startHttpClient();
    }

    private void startHttpClient() throws Exception {
        if (!this.httpClient.isStarted()) {
            this.httpClient.start();
        }
    }

    public void destroy() throws Exception {
        if (this.defaultClient && !this.httpClient.isStopped()) {
            this.httpClient.stop();
        }
    }

    @Override
    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        try {
            this.startHttpClient();
        }
        catch (Exception ex) {
            throw new IOException("Could not start HttpClient: " + ex.getMessage(), ex);
        }
        Request request = this.httpClient.newRequest(uri).method(httpMethod.name());
        return new JettyClientHttpRequest(request, this.timeOut);
    }
}

