/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.net.URI;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.client.AbstractStreamingClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.OkHttp3ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

class OkHttp3ClientHttpRequest
extends AbstractStreamingClientHttpRequest {
    private final OkHttpClient client;
    private final URI uri;
    private final HttpMethod method;

    public OkHttp3ClientHttpRequest(OkHttpClient client, URI uri, HttpMethod method) {
        this.client = client;
        this.uri = uri;
        this.method = method;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers, @Nullable StreamingHttpOutputMessage.Body body) throws IOException {
        BodyRequestBody requestBody;
        if (body != null) {
            requestBody = new BodyRequestBody(headers, body);
        } else if (okhttp3.internal.http.HttpMethod.requiresRequestBody((String)this.getMethod().name())) {
            String header = headers.getFirst("Content-Type");
            MediaType contentType = header != null ? MediaType.parse((String)header) : null;
            requestBody = RequestBody.create((MediaType)contentType, (byte[])new byte[0]);
        } else {
            requestBody = null;
        }
        Request.Builder builder = new Request.Builder().url(this.uri.toURL());
        builder.method(this.method.name(), (RequestBody)requestBody);
        headers.forEach((headerName, headerValues) -> {
            for (String headerValue : headerValues) {
                builder.addHeader(headerName, headerValue);
            }
        });
        Request request = builder.build();
        return new OkHttp3ClientHttpResponse(this.client.newCall(request).execute());
    }

    private static class BodyRequestBody
    extends RequestBody {
        private final HttpHeaders headers;
        private final StreamingHttpOutputMessage.Body body;

        public BodyRequestBody(HttpHeaders headers, StreamingHttpOutputMessage.Body body) {
            this.headers = headers;
            this.body = body;
        }

        public long contentLength() {
            return this.headers.getContentLength();
        }

        @Nullable
        public MediaType contentType() {
            String contentType = this.headers.getFirst("Content-Type");
            if (StringUtils.hasText((String)contentType)) {
                return MediaType.parse((String)contentType);
            }
            return null;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            this.body.writeTo(sink.outputStream());
        }

        public boolean isOneShot() {
            return true;
        }
    }
}

