/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.ErrorResponse;

public class MethodArgumentNotValidException
extends BindException
implements ErrorResponse {
    private final MethodParameter parameter;
    private final ProblemDetail body;

    public MethodArgumentNotValidException(MethodParameter parameter, BindingResult bindingResult) {
        super(bindingResult);
        this.parameter = parameter;
        this.body = ProblemDetail.forStatusAndDetail(this.getStatusCode(), "Invalid request content.");
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatus.BAD_REQUEST;
    }

    @Override
    public ProblemDetail getBody() {
        return this.body;
    }

    public final MethodParameter getParameter() {
        return this.parameter;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder("Validation failed for argument [").append(this.parameter.getParameterIndex()).append("] in ").append(this.parameter.getExecutable().toGenericString());
        BindingResult bindingResult = this.getBindingResult();
        if (bindingResult.getErrorCount() > 1) {
            sb.append(" with ").append(bindingResult.getErrorCount()).append(" errors");
        }
        sb.append(": ");
        for (ObjectError error : bindingResult.getAllErrors()) {
            sb.append('[').append(error).append("] ");
        }
        return sb.toString();
    }

    @Override
    public Object[] getDetailMessageArguments() {
        return new Object[]{MethodArgumentNotValidException.join(MethodArgumentNotValidException.formatErrors(this.getGlobalErrors(), null, null)), MethodArgumentNotValidException.join(MethodArgumentNotValidException.formatErrors(this.getFieldErrors(), null, null))};
    }

    @Override
    public Object[] getDetailMessageArguments(MessageSource messageSource, Locale locale) {
        return new Object[]{MethodArgumentNotValidException.join(MethodArgumentNotValidException.formatErrors(this.getGlobalErrors(), messageSource, locale)), MethodArgumentNotValidException.join(MethodArgumentNotValidException.formatErrors(this.getFieldErrors(), messageSource, locale))};
    }

    private static String join(List<String> errors) {
        return String.join((CharSequence)", and ", errors);
    }

    public Map<ObjectError, String> resolveErrorMessages(MessageSource source, Locale locale) {
        LinkedHashMap<ObjectError, String> map = new LinkedHashMap<ObjectError, String>(this.getErrorCount());
        this.getGlobalErrors().forEach(error -> map.put((ObjectError)error, MethodArgumentNotValidException.formatError(error, source, locale)));
        this.getFieldErrors().forEach(error -> map.put((ObjectError)error, MethodArgumentNotValidException.formatError((ObjectError)error, source, locale)));
        return map;
    }

    public static List<String> errorsToStringList(List<? extends ObjectError> errors) {
        return MethodArgumentNotValidException.formatErrors(errors, null, null);
    }

    public static List<String> errorsToStringList(List<? extends ObjectError> errors, @Nullable MessageSource source, Locale locale) {
        return MethodArgumentNotValidException.formatErrors(errors, source, locale);
    }

    public static List<String> formatErrors(List<? extends ObjectError> errors, @Nullable MessageSource messageSource, @Nullable Locale locale) {
        return errors.stream().map(error -> MethodArgumentNotValidException.formatError(error, messageSource, locale)).filter(StringUtils::hasText).toList();
    }

    private static String formatError(ObjectError error, @Nullable MessageSource messageSource, @Nullable Locale locale) {
        Object object;
        if (messageSource != null) {
            Assert.notNull((Object)locale, (String)"Expected MessageSource and locale");
            return messageSource.getMessage((MessageSourceResolvable)error, locale);
        }
        if (error instanceof FieldError) {
            FieldError fieldError = (FieldError)error;
            object = fieldError.getField() + ": ";
        } else {
            object = "";
        }
        String field = object;
        String message = error.getDefaultMessage() != null ? error.getDefaultMessage() : error.getCode();
        return field + message;
    }
}

