/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation;

import java.lang.reflect.Method;
import org.springframework.core.Conventions;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.lang.Nullable;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.DefaultMethodValidator;
import org.springframework.validation.beanvalidation.MethodValidationAdapter;
import org.springframework.validation.beanvalidation.MethodValidationResult;
import org.springframework.validation.beanvalidation.MethodValidator;
import org.springframework.validation.beanvalidation.ParameterErrors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.method.annotation.ModelFactory;

public final class HandlerMethodValidator
extends DefaultMethodValidator {
    private HandlerMethodValidator(MethodValidationAdapter adapter) {
        super(adapter);
    }

    protected void handleArgumentsValidationResult(Object bean, Method method, Object[] arguments, Class<?>[] groups, MethodValidationResult result) {
        if (result.getConstraintViolations().isEmpty()) {
            return;
        }
        if (!result.getBeanResults().isEmpty()) {
            int bindingResultCount = 0;
            block0: for (ParameterErrors errors : result.getBeanResults()) {
                for (Object arg : arguments) {
                    BindingResult bindingResult;
                    if (!(arg instanceof BindingResult) || !(bindingResult = (BindingResult)arg).getObjectName().equals(errors.getObjectName())) continue;
                    bindingResult.addAllErrors((Errors)errors);
                    ++bindingResultCount;
                    continue block0;
                }
            }
            if (result.getAllValidationResults().size() == bindingResultCount) {
                return;
            }
        }
        result.throwIfViolationsPresent();
    }

    private String determineObjectName(MethodParameter param, @Nullable Object argument) {
        if (param.hasParameterAnnotation(RequestBody.class) || param.hasParameterAnnotation(RequestPart.class)) {
            return Conventions.getVariableNameForParameter((MethodParameter)param);
        }
        return param.getParameterIndex() != -1 ? ModelFactory.getNameForParameter(param) : ModelFactory.getNameForReturnValue(argument, param);
    }

    @Nullable
    public static MethodValidator from(@Nullable WebBindingInitializer bindingInitializer, @Nullable ParameterNameDiscoverer parameterNameDiscoverer) {
        ConfigurableWebBindingInitializer configurableInitializer;
        Validator validator;
        if (bindingInitializer instanceof ConfigurableWebBindingInitializer && (validator = (configurableInitializer = (ConfigurableWebBindingInitializer)bindingInitializer).getValidator()) instanceof jakarta.validation.Validator) {
            MessageCodesResolver codesResolver;
            jakarta.validation.Validator validator2 = (jakarta.validation.Validator)validator;
            MethodValidationAdapter adapter = new MethodValidationAdapter(validator2);
            if (parameterNameDiscoverer != null) {
                adapter.setParameterNameDiscoverer(parameterNameDiscoverer);
            }
            if ((codesResolver = configurableInitializer.getMessageCodesResolver()) != null) {
                adapter.setMessageCodesResolver(codesResolver);
            }
            HandlerMethodValidator methodValidator = new HandlerMethodValidator(adapter);
            adapter.setBindingResultNameResolver(methodValidator::determineObjectName);
            return methodValidator;
        }
        return null;
    }
}

