/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.invoker;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.reactor.MonoKt;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringValueResolver;
import org.springframework.web.service.annotation.HttpExchange;
import org.springframework.web.service.invoker.CookieValueArgumentResolver;
import org.springframework.web.service.invoker.HttpClientAdapter;
import org.springframework.web.service.invoker.HttpMethodArgumentResolver;
import org.springframework.web.service.invoker.HttpServiceArgumentResolver;
import org.springframework.web.service.invoker.HttpServiceMethod;
import org.springframework.web.service.invoker.PathVariableArgumentResolver;
import org.springframework.web.service.invoker.RequestAttributeArgumentResolver;
import org.springframework.web.service.invoker.RequestBodyArgumentResolver;
import org.springframework.web.service.invoker.RequestHeaderArgumentResolver;
import org.springframework.web.service.invoker.RequestParamArgumentResolver;
import org.springframework.web.service.invoker.RequestPartArgumentResolver;
import org.springframework.web.service.invoker.UrlArgumentResolver;
import reactor.core.publisher.Mono;

public final class HttpServiceProxyFactory {
    private final HttpClientAdapter clientAdapter;
    private final List<HttpServiceArgumentResolver> argumentResolvers;
    @Nullable
    private final StringValueResolver embeddedValueResolver;
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;
    @Nullable
    private final Duration blockTimeout;

    private HttpServiceProxyFactory(HttpClientAdapter clientAdapter, List<HttpServiceArgumentResolver> argumentResolvers, @Nullable StringValueResolver embeddedValueResolver, ReactiveAdapterRegistry reactiveAdapterRegistry, @Nullable Duration blockTimeout) {
        this.clientAdapter = clientAdapter;
        this.argumentResolvers = argumentResolvers;
        this.embeddedValueResolver = embeddedValueResolver;
        this.reactiveAdapterRegistry = reactiveAdapterRegistry;
        this.blockTimeout = blockTimeout;
    }

    public <S> S createClient(Class<S> serviceType) {
        List<HttpServiceMethod> httpServiceMethods = MethodIntrospector.selectMethods(serviceType, this::isExchangeMethod).stream().map(method -> this.createHttpServiceMethod(serviceType, (Method)method)).toList();
        return (S)ProxyFactory.getProxy(serviceType, (Interceptor)new HttpServiceMethodInterceptor(httpServiceMethods));
    }

    private boolean isExchangeMethod(Method method) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, HttpExchange.class);
    }

    private <S> HttpServiceMethod createHttpServiceMethod(Class<S> serviceType, Method method) {
        Assert.notNull(this.argumentResolvers, (String)"No argument resolvers: afterPropertiesSet was not called");
        return new HttpServiceMethod(method, serviceType, this.argumentResolvers, this.clientAdapter, this.embeddedValueResolver, this.reactiveAdapterRegistry, this.blockTimeout);
    }

    public static Builder builder(HttpClientAdapter clientAdapter) {
        return new Builder().clientAdapter(clientAdapter);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class HttpServiceMethodInterceptor
    implements MethodInterceptor {
        private final Map<Method, HttpServiceMethod> httpServiceMethods;

        private HttpServiceMethodInterceptor(List<HttpServiceMethod> methods) {
            this.httpServiceMethods = methods.stream().collect(Collectors.toMap(HttpServiceMethod::getMethod, Function.identity()));
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            HttpServiceMethod httpServiceMethod = this.httpServiceMethods.get(method);
            if (httpServiceMethod != null) {
                if (KotlinDetector.isSuspendingFunction((Method)method)) {
                    return KotlinDelegate.invokeSuspendingFunction(invocation, httpServiceMethod);
                }
                return httpServiceMethod.invoke(invocation.getArguments());
            }
            if (method.isDefault() && invocation instanceof ReflectiveMethodInvocation) {
                ReflectiveMethodInvocation reflectiveMethodInvocation = (ReflectiveMethodInvocation)invocation;
                Object proxy = reflectiveMethodInvocation.getProxy();
                return InvocationHandler.invokeDefault(proxy, method, invocation.getArguments());
            }
            throw new IllegalStateException("Unexpected method invocation: " + method);
        }
    }

    public static final class Builder {
        @Nullable
        private HttpClientAdapter clientAdapter;
        private final List<HttpServiceArgumentResolver> customArgumentResolvers = new ArrayList<HttpServiceArgumentResolver>();
        @Nullable
        private ConversionService conversionService;
        @Nullable
        private StringValueResolver embeddedValueResolver;
        private ReactiveAdapterRegistry reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();
        @Nullable
        private Duration blockTimeout;

        private Builder() {
        }

        public Builder clientAdapter(HttpClientAdapter clientAdapter) {
            this.clientAdapter = clientAdapter;
            return this;
        }

        public Builder customArgumentResolver(HttpServiceArgumentResolver resolver) {
            this.customArgumentResolvers.add(resolver);
            return this;
        }

        public Builder conversionService(ConversionService conversionService) {
            this.conversionService = conversionService;
            return this;
        }

        public Builder embeddedValueResolver(StringValueResolver embeddedValueResolver) {
            this.embeddedValueResolver = embeddedValueResolver;
            return this;
        }

        public Builder reactiveAdapterRegistry(ReactiveAdapterRegistry registry) {
            this.reactiveAdapterRegistry = registry;
            return this;
        }

        public Builder blockTimeout(@Nullable Duration blockTimeout) {
            this.blockTimeout = blockTimeout;
            return this;
        }

        public HttpServiceProxyFactory build() {
            Assert.notNull((Object)this.clientAdapter, (String)"HttpClientAdapter is required");
            return new HttpServiceProxyFactory(this.clientAdapter, this.initArgumentResolvers(), this.embeddedValueResolver, this.reactiveAdapterRegistry, this.blockTimeout);
        }

        private List<HttpServiceArgumentResolver> initArgumentResolvers() {
            ArrayList<HttpServiceArgumentResolver> resolvers = new ArrayList<HttpServiceArgumentResolver>(this.customArgumentResolvers);
            ConversionService service = this.conversionService != null ? this.conversionService : new DefaultFormattingConversionService();
            resolvers.add(new RequestHeaderArgumentResolver(service));
            resolvers.add(new RequestBodyArgumentResolver(this.reactiveAdapterRegistry));
            resolvers.add(new PathVariableArgumentResolver(service));
            resolvers.add(new RequestParamArgumentResolver(service));
            resolvers.add(new RequestPartArgumentResolver(this.reactiveAdapterRegistry));
            resolvers.add(new CookieValueArgumentResolver(service));
            resolvers.add(new RequestAttributeArgumentResolver());
            resolvers.add(new UrlArgumentResolver());
            resolvers.add(new HttpMethodArgumentResolver());
            return resolvers;
        }
    }

    private static class KotlinDelegate {
        private KotlinDelegate() {
        }

        public static Object invokeSuspendingFunction(MethodInvocation invocation, HttpServiceMethod httpServiceMethod) {
            Object[] rawArguments = invocation.getArguments();
            Object[] arguments = KotlinDelegate.resolveArguments(rawArguments);
            Continuation continuation = (Continuation)rawArguments[rawArguments.length - 1];
            Mono wrapped = (Mono)httpServiceMethod.invoke(arguments);
            return MonoKt.awaitSingleOrNull((Mono)wrapped, (Continuation)continuation);
        }

        private static Object[] resolveArguments(Object[] args) {
            Object[] functionArgs = new Object[args.length - 1];
            System.arraycopy(args, 0, functionArgs, 0, args.length - 1);
            return functionArgs;
        }
    }
}

