/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.invoker;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationPredicates;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;
import org.springframework.web.service.annotation.HttpExchange;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.service.invoker.HttpServiceArgumentResolver;
import org.springframework.web.service.invoker.ReactiveHttpRequestValues;
import org.springframework.web.service.invoker.ReactorHttpExchangeAdapter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class HttpServiceMethod {
    private static final boolean REACTOR_PRESENT = ClassUtils.isPresent((String)"reactor.core.publisher.Mono", (ClassLoader)HttpServiceMethod.class.getClassLoader());
    private final Method method;
    private final MethodParameter[] parameters;
    private final List<HttpServiceArgumentResolver> argumentResolvers;
    private final HttpRequestValuesInitializer requestValuesInitializer;
    private final ResponseFunction responseFunction;

    HttpServiceMethod(Method method, Class<?> containingClass, List<HttpServiceArgumentResolver> argumentResolvers, HttpExchangeAdapter adapter, @Nullable StringValueResolver embeddedValueResolver) {
        this.method = method;
        this.parameters = HttpServiceMethod.initMethodParameters(method);
        this.argumentResolvers = argumentResolvers;
        boolean isReactorAdapter = REACTOR_PRESENT && adapter instanceof ReactorHttpExchangeAdapter;
        this.requestValuesInitializer = HttpRequestValuesInitializer.create(method, containingClass, embeddedValueResolver, isReactorAdapter ? ReactiveHttpRequestValues::builder : HttpRequestValues::builder);
        this.responseFunction = isReactorAdapter ? ReactorExchangeResponseFunction.create((ReactorHttpExchangeAdapter)adapter, method) : ExchangeResponseFunction.create(adapter, method);
    }

    private static MethodParameter[] initMethodParameters(Method method) {
        int count = method.getParameterCount();
        if (count == 0) {
            return new MethodParameter[0];
        }
        if (KotlinDetector.isSuspendingFunction((Method)method)) {
            --count;
        }
        DefaultParameterNameDiscoverer nameDiscoverer = new DefaultParameterNameDiscoverer();
        MethodParameter[] parameters = new MethodParameter[count];
        for (int i = 0; i < count; ++i) {
            parameters[i] = new SynthesizingMethodParameter(method, i);
            parameters[i].initParameterNameDiscovery((ParameterNameDiscoverer)nameDiscoverer);
        }
        return parameters;
    }

    public Method getMethod() {
        return this.method;
    }

    @Nullable
    public Object invoke(Object[] arguments) {
        HttpRequestValues.Builder requestValues = this.requestValuesInitializer.initializeRequestValuesBuilder();
        this.applyArguments(requestValues, arguments);
        return this.responseFunction.execute(requestValues.build());
    }

    private void applyArguments(HttpRequestValues.Builder requestValues, Object[] arguments) {
        Assert.isTrue((arguments.length == this.parameters.length ? 1 : 0) != 0, (String)"Method argument mismatch");
        int i = 0;
        while (i < arguments.length) {
            Object value = arguments[i];
            boolean resolved = false;
            for (HttpServiceArgumentResolver resolver : this.argumentResolvers) {
                if (!resolver.resolve(value, this.parameters[i], requestValues)) continue;
                resolved = true;
                break;
            }
            int index = i++;
            Assert.state((boolean)resolved, () -> "Could not resolve parameter [" + this.parameters[index].getParameterIndex() + "] in " + this.parameters[index].getExecutable().toGenericString() + ": No suitable resolver");
        }
    }

    private record HttpRequestValuesInitializer(@Nullable HttpMethod httpMethod, @Nullable String url, @Nullable MediaType contentType, @Nullable List<MediaType> acceptMediaTypes, Supplier<HttpRequestValues.Builder> requestValuesSupplier) {
        public HttpRequestValues.Builder initializeRequestValuesBuilder() {
            HttpRequestValues.Builder requestValues = this.requestValuesSupplier.get();
            if (this.httpMethod != null) {
                requestValues.setHttpMethod(this.httpMethod);
            }
            if (this.url != null) {
                requestValues.setUriTemplate(this.url);
            }
            if (this.contentType != null) {
                requestValues.setContentType(this.contentType);
            }
            if (this.acceptMediaTypes != null) {
                requestValues.setAccept(this.acceptMediaTypes);
            }
            return requestValues;
        }

        public static HttpRequestValuesInitializer create(Method method, Class<?> containingClass, @Nullable StringValueResolver embeddedValueResolver, Supplier<HttpRequestValues.Builder> requestValuesSupplier) {
            List<AnnotationDescriptor> methodHttpExchanges = HttpRequestValuesInitializer.getAnnotationDescriptors(method);
            Assert.state((!methodHttpExchanges.isEmpty() ? 1 : 0) != 0, () -> "Expected @HttpExchange annotation on method " + method);
            Assert.state((methodHttpExchanges.size() == 1 ? 1 : 0) != 0, () -> "Multiple @HttpExchange annotations found on method %s, but only one is allowed: %s".formatted(method, methodHttpExchanges));
            List<AnnotationDescriptor> typeHttpExchanges = HttpRequestValuesInitializer.getAnnotationDescriptors(containingClass);
            Assert.state((typeHttpExchanges.size() <= 1 ? 1 : 0) != 0, () -> "Multiple @HttpExchange annotations found on %s, but only one is allowed: %s".formatted(containingClass, typeHttpExchanges));
            HttpExchange methodAnnotation = methodHttpExchanges.get((int)0).httpExchange;
            HttpExchange typeAnnotation = !typeHttpExchanges.isEmpty() ? typeHttpExchanges.get((int)0).httpExchange : null;
            HttpMethod httpMethod = HttpRequestValuesInitializer.initHttpMethod(typeAnnotation, methodAnnotation);
            String url = HttpRequestValuesInitializer.initUrl(typeAnnotation, methodAnnotation, embeddedValueResolver);
            MediaType contentType = HttpRequestValuesInitializer.initContentType(typeAnnotation, methodAnnotation);
            List<MediaType> acceptableMediaTypes = HttpRequestValuesInitializer.initAccept(typeAnnotation, methodAnnotation);
            return new HttpRequestValuesInitializer(httpMethod, url, contentType, acceptableMediaTypes, requestValuesSupplier);
        }

        @Nullable
        private static HttpMethod initHttpMethod(@Nullable HttpExchange typeAnnotation, HttpExchange methodAnnotation) {
            String typeLevelMethod;
            String methodLevelMethod = methodAnnotation.method();
            if (StringUtils.hasText((String)methodLevelMethod)) {
                return HttpMethod.valueOf(methodLevelMethod);
            }
            String string = typeLevelMethod = typeAnnotation != null ? typeAnnotation.method() : null;
            if (StringUtils.hasText((String)typeLevelMethod)) {
                return HttpMethod.valueOf(typeLevelMethod);
            }
            return null;
        }

        @Nullable
        private static String initUrl(@Nullable HttpExchange typeAnnotation, HttpExchange methodAnnotation, @Nullable StringValueResolver embeddedValueResolver) {
            String typeLevelUrl = typeAnnotation != null ? typeAnnotation.url() : null;
            String methodLevelUrl = methodAnnotation.url();
            if (embeddedValueResolver != null) {
                typeLevelUrl = typeLevelUrl != null ? embeddedValueResolver.resolveStringValue(typeLevelUrl) : null;
                methodLevelUrl = embeddedValueResolver.resolveStringValue(methodLevelUrl);
            }
            boolean hasTypeLevelUrl = StringUtils.hasText((String)typeLevelUrl);
            boolean hasMethodLevelUrl = StringUtils.hasText((String)methodLevelUrl);
            if (hasTypeLevelUrl && hasMethodLevelUrl) {
                return typeLevelUrl + (!typeLevelUrl.endsWith("/") && !methodLevelUrl.startsWith("/") ? "/" : "") + methodLevelUrl;
            }
            if (!hasTypeLevelUrl && !hasMethodLevelUrl) {
                return null;
            }
            return hasMethodLevelUrl ? methodLevelUrl : typeLevelUrl;
        }

        @Nullable
        private static MediaType initContentType(@Nullable HttpExchange typeAnnotation, HttpExchange methodAnnotation) {
            String typeLevelContentType;
            String methodLevelContentType = methodAnnotation.contentType();
            if (StringUtils.hasText((String)methodLevelContentType)) {
                return MediaType.parseMediaType(methodLevelContentType);
            }
            String string = typeLevelContentType = typeAnnotation != null ? typeAnnotation.contentType() : null;
            if (StringUtils.hasText((String)typeLevelContentType)) {
                return MediaType.parseMediaType(typeLevelContentType);
            }
            return null;
        }

        @Nullable
        private static List<MediaType> initAccept(@Nullable HttpExchange typeAnnotation, HttpExchange methodAnnotation) {
            Object[] typeLevelAccept;
            Object[] methodLevelAccept = methodAnnotation.accept();
            if (!ObjectUtils.isEmpty((Object[])methodLevelAccept)) {
                return MediaType.parseMediaTypes(List.of(methodLevelAccept));
            }
            Object[] objectArray = typeLevelAccept = typeAnnotation != null ? typeAnnotation.accept() : null;
            if (!ObjectUtils.isEmpty((Object[])typeLevelAccept)) {
                return MediaType.parseMediaTypes(List.of(typeLevelAccept));
            }
            return null;
        }

        private static List<AnnotationDescriptor> getAnnotationDescriptors(AnnotatedElement element) {
            return MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY, (RepeatableContainers)RepeatableContainers.none()).stream(HttpExchange.class).filter(MergedAnnotationPredicates.firstRunOf(MergedAnnotation::getAggregateIndex)).map(AnnotationDescriptor::new).distinct().toList();
        }

        private static class AnnotationDescriptor {
            private final HttpExchange httpExchange;
            private final MergedAnnotation<?> root;

            AnnotationDescriptor(MergedAnnotation<HttpExchange> mergedAnnotation) {
                this.httpExchange = (HttpExchange)mergedAnnotation.synthesize();
                this.root = mergedAnnotation.getRoot();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object obj) {
                if (!(obj instanceof AnnotationDescriptor)) return false;
                AnnotationDescriptor that = (AnnotationDescriptor)obj;
                if (!this.httpExchange.equals(that.httpExchange)) return false;
                return true;
            }

            public int hashCode() {
                return this.httpExchange.hashCode();
            }

            public String toString() {
                return this.root.synthesize().toString();
            }
        }
    }

    private record ReactorExchangeResponseFunction(Function<HttpRequestValues, Publisher<?>> responseFunction, @Nullable ReactiveAdapter returnTypeAdapter, boolean blockForOptional, @Nullable Duration blockTimeout) implements ResponseFunction
    {
        @Override
        @Nullable
        public Object execute(HttpRequestValues requestValues) {
            Publisher<?> responsePublisher = this.responseFunction.apply(requestValues);
            if (this.returnTypeAdapter != null) {
                return this.returnTypeAdapter.fromPublisher(responsePublisher);
            }
            if (this.blockForOptional) {
                return this.blockTimeout != null ? ((Mono)responsePublisher).blockOptional(this.blockTimeout) : ((Mono)responsePublisher).blockOptional();
            }
            return this.blockTimeout != null ? ((Mono)responsePublisher).block(this.blockTimeout) : ((Mono)responsePublisher).block();
        }

        public static ResponseFunction create(ReactorHttpExchangeAdapter client, Method method) {
            Function<HttpRequestValues, Publisher<?>> responseFunction;
            Class actualType;
            ReactiveAdapter reactiveAdapter;
            MethodParameter returnParam = new MethodParameter(method, -1);
            Class<Mono> returnType = returnParam.getParameterType();
            boolean isSuspending = KotlinDetector.isSuspendingFunction((Method)method);
            if (isSuspending) {
                returnType = Mono.class;
            }
            MethodParameter actualParam = (reactiveAdapter = client.getReactiveAdapterRegistry().getAdapter(returnType)) != null ? returnParam.nested() : returnParam.nestedIfOptional();
            Class clazz = actualType = isSuspending ? actualParam.getParameterType() : actualParam.getNestedParameterType();
            if (ClassUtils.isVoidType((Class)actualType)) {
                responseFunction = client::exchangeForMono;
            } else if (reactiveAdapter != null && reactiveAdapter.isNoValue()) {
                responseFunction = client::exchangeForMono;
            } else if (actualType.equals(HttpHeaders.class)) {
                responseFunction = client::exchangeForHeadersMono;
            } else if (actualType.equals(ResponseEntity.class)) {
                MethodParameter bodyParam = isSuspending ? actualParam : actualParam.nested();
                Class bodyType = bodyParam.getNestedParameterType();
                if (bodyType.equals(Void.class)) {
                    responseFunction = client::exchangeForBodilessEntityMono;
                } else {
                    ReactiveAdapter bodyAdapter = client.getReactiveAdapterRegistry().getAdapter(bodyType);
                    responseFunction = ReactorExchangeResponseFunction.initResponseEntityFunction(client, bodyParam, bodyAdapter, isSuspending);
                }
            } else {
                responseFunction = ReactorExchangeResponseFunction.initBodyFunction(client, actualParam, reactiveAdapter, isSuspending);
            }
            return new ReactorExchangeResponseFunction(responseFunction, reactiveAdapter, returnType.equals(Optional.class), client.getBlockTimeout());
        }

        private static Function<HttpRequestValues, Publisher<?>> initResponseEntityFunction(ReactorHttpExchangeAdapter client, MethodParameter methodParam, @Nullable ReactiveAdapter reactiveAdapter, boolean isSuspending) {
            if (reactiveAdapter == null) {
                return request -> client.exchangeForEntityMono((HttpRequestValues)request, ParameterizedTypeReference.forType((Type)methodParam.getNestedGenericParameterType()));
            }
            Assert.isTrue((boolean)reactiveAdapter.isMultiValue(), (String)"ResponseEntity body must be a concrete value or a multi-value Publisher");
            ParameterizedTypeReference bodyType = ParameterizedTypeReference.forType((Type)(isSuspending ? methodParam.nested().getGenericParameterType() : methodParam.nested().getNestedGenericParameterType()));
            if (reactiveAdapter.getReactiveType().equals(Flux.class)) {
                return request -> client.exchangeForEntityFlux((HttpRequestValues)request, bodyType);
            }
            return request -> client.exchangeForEntityFlux((HttpRequestValues)request, bodyType).map(entity -> {
                Flux entityBody = (Flux)entity.getBody();
                Assert.state((entityBody != null ? 1 : 0) != 0, (String)"Entity body must not be null");
                Object body2 = reactiveAdapter.fromPublisher((Publisher)entityBody);
                return new ResponseEntity<Object>(body2, (MultiValueMap<String, String>)entity.getHeaders(), entity.getStatusCode());
            });
        }

        private static Function<HttpRequestValues, Publisher<?>> initBodyFunction(ReactorHttpExchangeAdapter client, MethodParameter methodParam, @Nullable ReactiveAdapter reactiveAdapter, boolean isSuspending) {
            ParameterizedTypeReference bodyType = ParameterizedTypeReference.forType((Type)(isSuspending ? methodParam.getGenericParameterType() : methodParam.getNestedGenericParameterType()));
            return reactiveAdapter != null && reactiveAdapter.isMultiValue() ? request -> client.exchangeForBodyFlux((HttpRequestValues)request, bodyType) : request -> client.exchangeForBodyMono((HttpRequestValues)request, bodyType);
        }
    }

    private static interface ResponseFunction {
        @Nullable
        public Object execute(HttpRequestValues var1);
    }

    private record ExchangeResponseFunction(Function<HttpRequestValues, Object> responseFunction) implements ResponseFunction
    {
        @Override
        public Object execute(HttpRequestValues requestValues) {
            return this.responseFunction.apply(requestValues);
        }

        public static ResponseFunction create(HttpExchangeAdapter client, Method method) {
            Function<HttpRequestValues, Object> responseFunction;
            if (KotlinDetector.isSuspendingFunction((Method)method)) {
                throw new IllegalStateException("Kotlin Coroutines are only supported with reactive implementations");
            }
            MethodParameter param = new MethodParameter(method, -1).nestedIfOptional();
            Class paramType = param.getNestedParameterType();
            if (ClassUtils.isVoidType((Class)paramType)) {
                responseFunction = requestValues -> {
                    client.exchange((HttpRequestValues)requestValues);
                    return null;
                };
            } else if (paramType.equals(HttpHeaders.class)) {
                responseFunction = request -> ExchangeResponseFunction.asOptionalIfNecessary(client.exchangeForHeaders((HttpRequestValues)request), param);
            } else if (paramType.equals(ResponseEntity.class)) {
                MethodParameter bodyParam = param.nested();
                if (bodyParam.getNestedParameterType().equals(Void.class)) {
                    responseFunction = request -> ExchangeResponseFunction.asOptionalIfNecessary(client.exchangeForBodilessEntity((HttpRequestValues)request), param);
                } else {
                    ParameterizedTypeReference bodyTypeRef = ParameterizedTypeReference.forType((Type)bodyParam.getNestedGenericParameterType());
                    responseFunction = request -> ExchangeResponseFunction.asOptionalIfNecessary(client.exchangeForEntity((HttpRequestValues)request, bodyTypeRef), param);
                }
            } else {
                ParameterizedTypeReference bodyTypeRef = ParameterizedTypeReference.forType((Type)param.getNestedGenericParameterType());
                responseFunction = request -> ExchangeResponseFunction.asOptionalIfNecessary(client.exchangeForBody((HttpRequestValues)request, bodyTypeRef), param);
            }
            return new ExchangeResponseFunction(responseFunction);
        }

        @Nullable
        private static Object asOptionalIfNecessary(@Nullable Object response, MethodParameter param) {
            return param.getParameterType().equals(Optional.class) ? Optional.ofNullable(response) : response;
        }
    }
}

