/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverSupport;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

public class WebSessionMethodArgumentResolver
extends HandlerMethodArgumentResolverSupport {
    public WebSessionMethodArgumentResolver(ReactiveAdapterRegistry adapterRegistry) {
        super(adapterRegistry);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return this.checkParameterType(parameter, WebSession.class::isAssignableFrom);
    }

    @Override
    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext context, ServerWebExchange exchange) {
        Mono session = exchange.getSession();
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(parameter.getParameterType());
        return adapter != null ? Mono.just((Object)adapter.fromPublisher((Publisher)session)) : Mono.from((Publisher)session);
    }
}

