/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientHttpObservationDocumentation;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientRequestObservationContext;
import org.springframework.web.reactive.function.client.ClientRequestObservationConvention;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.DefaultClientRequestObservationConvention;
import org.springframework.web.reactive.function.client.DefaultWebClientBuilder;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientUtils;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriBuilderFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.util.context.Context;

final class DefaultWebClient
implements WebClient {
    private static final String URI_TEMPLATE_ATTRIBUTE = WebClient.class.getName() + ".uriTemplate";
    private static final Mono<ClientResponse> NO_HTTP_CLIENT_RESPONSE_ERROR = Mono.error(() -> new IllegalStateException("The underlying HTTP client completed without emitting a response."));
    private static final DefaultClientRequestObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultClientRequestObservationConvention();
    private final ExchangeFunction exchangeFunction;
    @Nullable
    private final ExchangeFilterFunction filterFunctions;
    private final UriBuilderFactory uriBuilderFactory;
    @Nullable
    private final HttpHeaders defaultHeaders;
    @Nullable
    private final MultiValueMap<String, String> defaultCookies;
    @Nullable
    private final Consumer<WebClient.RequestHeadersSpec<?>> defaultRequest;
    private final List<DefaultResponseSpec.StatusHandler> defaultStatusHandlers;
    private final ObservationRegistry observationRegistry;
    @Nullable
    private final ClientRequestObservationConvention observationConvention;
    private final DefaultWebClientBuilder builder;

    DefaultWebClient(ExchangeFunction exchangeFunction, @Nullable ExchangeFilterFunction filterFunctions, UriBuilderFactory uriBuilderFactory, @Nullable HttpHeaders defaultHeaders, @Nullable MultiValueMap<String, String> defaultCookies, @Nullable Consumer<WebClient.RequestHeadersSpec<?>> defaultRequest, @Nullable Map<Predicate<HttpStatusCode>, Function<ClientResponse, Mono<? extends Throwable>>> statusHandlerMap, ObservationRegistry observationRegistry, @Nullable ClientRequestObservationConvention observationConvention, DefaultWebClientBuilder builder) {
        this.exchangeFunction = exchangeFunction;
        this.filterFunctions = filterFunctions;
        this.uriBuilderFactory = uriBuilderFactory;
        this.defaultHeaders = defaultHeaders;
        this.defaultCookies = defaultCookies;
        this.defaultRequest = defaultRequest;
        this.defaultStatusHandlers = DefaultWebClient.initStatusHandlers(statusHandlerMap);
        this.observationRegistry = observationRegistry;
        this.observationConvention = observationConvention;
        this.builder = builder;
    }

    private static List<DefaultResponseSpec.StatusHandler> initStatusHandlers(@Nullable Map<Predicate<HttpStatusCode>, Function<ClientResponse, Mono<? extends Throwable>>> handlerMap) {
        return CollectionUtils.isEmpty(handlerMap) ? Collections.emptyList() : handlerMap.entrySet().stream().map(entry -> new DefaultResponseSpec.StatusHandler((Predicate)entry.getKey(), (Function)entry.getValue())).toList();
    }

    @Override
    public WebClient.RequestHeadersUriSpec<?> get() {
        return this.methodInternal(HttpMethod.GET);
    }

    @Override
    public WebClient.RequestHeadersUriSpec<?> head() {
        return this.methodInternal(HttpMethod.HEAD);
    }

    @Override
    public WebClient.RequestBodyUriSpec post() {
        return this.methodInternal(HttpMethod.POST);
    }

    @Override
    public WebClient.RequestBodyUriSpec put() {
        return this.methodInternal(HttpMethod.PUT);
    }

    @Override
    public WebClient.RequestBodyUriSpec patch() {
        return this.methodInternal(HttpMethod.PATCH);
    }

    @Override
    public WebClient.RequestHeadersUriSpec<?> delete() {
        return this.methodInternal(HttpMethod.DELETE);
    }

    @Override
    public WebClient.RequestHeadersUriSpec<?> options() {
        return this.methodInternal(HttpMethod.OPTIONS);
    }

    @Override
    public WebClient.RequestBodyUriSpec method(HttpMethod httpMethod) {
        return this.methodInternal(httpMethod);
    }

    private WebClient.RequestBodyUriSpec methodInternal(HttpMethod httpMethod) {
        return new DefaultRequestBodyUriSpec(httpMethod);
    }

    @Override
    public WebClient.Builder mutate() {
        return new DefaultWebClientBuilder(this.builder);
    }

    private static Mono<Void> releaseIfNotConsumed(ClientResponse response) {
        return response.releaseBody().onErrorComplete();
    }

    private static <T> Mono<T> releaseIfNotConsumed(ClientResponse response, Throwable ex) {
        return response.releaseBody().onErrorComplete().then(Mono.error((Throwable)ex));
    }

    private class DefaultRequestBodyUriSpec
    implements WebClient.RequestBodyUriSpec {
        private final HttpMethod httpMethod;
        @Nullable
        private URI uri;
        @Nullable
        private HttpHeaders headers;
        @Nullable
        private MultiValueMap<String, String> cookies;
        @Nullable
        private BodyInserter<?, ? super ClientHttpRequest> inserter;
        private final Map<String, Object> attributes = new LinkedHashMap<String, Object>(4);
        @Nullable
        private Function<Context, Context> contextModifier;
        @Nullable
        private Consumer<ClientHttpRequest> httpRequestConsumer;

        DefaultRequestBodyUriSpec(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        public WebClient.RequestBodySpec uri(String uriTemplate, Object ... uriVariables) {
            this.attribute(URI_TEMPLATE_ATTRIBUTE, uriTemplate);
            return this.uri(DefaultWebClient.this.uriBuilderFactory.expand(uriTemplate, uriVariables));
        }

        @Override
        public WebClient.RequestBodySpec uri(String uriTemplate, Map<String, ?> uriVariables) {
            this.attribute(URI_TEMPLATE_ATTRIBUTE, uriTemplate);
            return this.uri(DefaultWebClient.this.uriBuilderFactory.expand(uriTemplate, uriVariables));
        }

        @Override
        public WebClient.RequestBodySpec uri(String uriTemplate, Function<UriBuilder, URI> uriFunction) {
            this.attribute(URI_TEMPLATE_ATTRIBUTE, uriTemplate);
            return this.uri(uriFunction.apply(DefaultWebClient.this.uriBuilderFactory.uriString(uriTemplate)));
        }

        @Override
        public WebClient.RequestBodySpec uri(Function<UriBuilder, URI> uriFunction) {
            return this.uri(uriFunction.apply(DefaultWebClient.this.uriBuilderFactory.builder()));
        }

        @Override
        public WebClient.RequestBodySpec uri(URI uri) {
            this.uri = uri;
            return this;
        }

        private HttpHeaders getHeaders() {
            if (this.headers == null) {
                this.headers = new HttpHeaders();
            }
            return this.headers;
        }

        private MultiValueMap<String, String> getCookies() {
            if (this.cookies == null) {
                this.cookies = new LinkedMultiValueMap(3);
            }
            return this.cookies;
        }

        @Override
        public DefaultRequestBodyUriSpec header(String headerName, String ... headerValues) {
            for (String headerValue : headerValues) {
                this.getHeaders().add(headerName, headerValue);
            }
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec headers(Consumer<HttpHeaders> headersConsumer) {
            headersConsumer.accept(this.getHeaders());
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec accept(MediaType ... acceptableMediaTypes) {
            this.getHeaders().setAccept(Arrays.asList(acceptableMediaTypes));
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec acceptCharset(Charset ... acceptableCharsets) {
            this.getHeaders().setAcceptCharset(Arrays.asList(acceptableCharsets));
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec contentType(MediaType contentType) {
            this.getHeaders().setContentType(contentType);
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec contentLength(long contentLength) {
            this.getHeaders().setContentLength(contentLength);
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec cookie(String name, String value) {
            this.getCookies().add((Object)name, (Object)value);
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec cookies(Consumer<MultiValueMap<String, String>> cookiesConsumer) {
            cookiesConsumer.accept(this.getCookies());
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec ifModifiedSince(ZonedDateTime ifModifiedSince) {
            this.getHeaders().setIfModifiedSince(ifModifiedSince);
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec ifNoneMatch(String ... ifNoneMatches) {
            this.getHeaders().setIfNoneMatch(Arrays.asList(ifNoneMatches));
            return this;
        }

        @Override
        public WebClient.RequestBodySpec attribute(String name, Object value) {
            this.attributes.put(name, value);
            return this;
        }

        @Override
        public WebClient.RequestBodySpec attributes(Consumer<Map<String, Object>> attributesConsumer) {
            attributesConsumer.accept(this.attributes);
            return this;
        }

        @Override
        public WebClient.RequestBodySpec context(Function<Context, Context> contextModifier) {
            this.contextModifier = this.contextModifier != null ? this.contextModifier.andThen(contextModifier) : contextModifier;
            return this;
        }

        @Override
        public WebClient.RequestBodySpec httpRequest(Consumer<ClientHttpRequest> requestConsumer) {
            this.httpRequestConsumer = this.httpRequestConsumer != null ? this.httpRequestConsumer.andThen(requestConsumer) : requestConsumer;
            return this;
        }

        @Override
        public WebClient.RequestHeadersSpec<?> bodyValue(Object body2) {
            this.inserter = BodyInserters.fromValue(body2);
            return this;
        }

        @Override
        public <T, P extends Publisher<T>> WebClient.RequestHeadersSpec<?> body(P publisher, ParameterizedTypeReference<T> elementTypeRef) {
            this.inserter = BodyInserters.fromPublisher(publisher, elementTypeRef);
            return this;
        }

        @Override
        public <T, P extends Publisher<T>> WebClient.RequestHeadersSpec<?> body(P publisher, Class<T> elementClass) {
            this.inserter = BodyInserters.fromPublisher(publisher, elementClass);
            return this;
        }

        @Override
        public WebClient.RequestHeadersSpec<?> body(Object producer, Class<?> elementClass) {
            this.inserter = BodyInserters.fromProducer(producer, elementClass);
            return this;
        }

        @Override
        public WebClient.RequestHeadersSpec<?> body(Object producer, ParameterizedTypeReference<?> elementTypeRef) {
            this.inserter = BodyInserters.fromProducer(producer, elementTypeRef);
            return this;
        }

        @Override
        public WebClient.RequestHeadersSpec<?> body(BodyInserter<?, ? super ClientHttpRequest> inserter) {
            this.inserter = inserter;
            return this;
        }

        @Override
        @Deprecated
        public WebClient.RequestHeadersSpec<?> syncBody(Object body2) {
            return this.bodyValue(body2);
        }

        @Override
        public WebClient.ResponseSpec retrieve() {
            return new DefaultResponseSpec(this.httpMethod, this.initUri(), this.exchange(), DefaultWebClient.this.defaultStatusHandlers);
        }

        @Override
        public <V> Mono<V> exchangeToMono(Function<ClientResponse, ? extends Mono<V>> responseHandler) {
            return this.exchange().flatMap(response -> {
                try {
                    return ((Mono)responseHandler.apply((ClientResponse)response)).flatMap(value -> DefaultWebClient.releaseIfNotConsumed(response).thenReturn(value)).switchIfEmpty(Mono.defer(() -> DefaultWebClient.releaseIfNotConsumed(response).then(Mono.empty()))).onErrorResume(ex -> DefaultWebClient.releaseIfNotConsumed(response, ex));
                }
                catch (Throwable ex2) {
                    return DefaultWebClient.releaseIfNotConsumed(response, ex2);
                }
            });
        }

        @Override
        public <V> Flux<V> exchangeToFlux(Function<ClientResponse, ? extends Flux<V>> responseHandler) {
            return this.exchange().flatMapMany(response -> {
                try {
                    return ((Flux)responseHandler.apply((ClientResponse)response)).concatWith((Publisher)Flux.defer(() -> DefaultWebClient.releaseIfNotConsumed(response).then(Mono.empty()))).onErrorResume(ex -> DefaultWebClient.releaseIfNotConsumed(response, ex));
                }
                catch (Throwable ex2) {
                    return DefaultWebClient.releaseIfNotConsumed(response, ex2);
                }
            });
        }

        @Override
        public Mono<ClientResponse> exchange() {
            ClientRequestObservationContext observationContext = new ClientRequestObservationContext();
            ClientRequest.Builder requestBuilder = this.initRequestBuilder();
            return Mono.deferContextual(contextView -> {
                Observation observation = ClientHttpObservationDocumentation.HTTP_REACTIVE_CLIENT_EXCHANGES.observation(DefaultWebClient.this.observationConvention, DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, DefaultWebClient.this.observationRegistry);
                observationContext.setCarrier(requestBuilder);
                observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
                ExchangeFilterFunction filterFunction = new ObservationFilterFunction(observationContext);
                if (DefaultWebClient.this.filterFunctions != null) {
                    filterFunction = DefaultWebClient.this.filterFunctions.andThen(filterFunction);
                }
                ClientRequest request = requestBuilder.build();
                observationContext.setUriTemplate(request.attribute(URI_TEMPLATE_ATTRIBUTE).orElse(null));
                observationContext.setRequest(request);
                Mono responseMono = filterFunction.apply(DefaultWebClient.this.exchangeFunction).exchange(request).checkpoint("Request to " + this.httpMethod.name() + " " + this.uri + " [DefaultWebClient]").switchIfEmpty(NO_HTTP_CLIENT_RESPONSE_ERROR);
                if (this.contextModifier != null) {
                    responseMono = responseMono.contextWrite(this.contextModifier);
                }
                AtomicBoolean responseReceived = new AtomicBoolean();
                return responseMono.doOnNext(response -> responseReceived.set(true)).doOnError(arg_0 -> ((ClientRequestObservationContext)observationContext).setError(arg_0)).doFinally(signalType -> {
                    if (signalType == SignalType.CANCEL && !responseReceived.get()) {
                        observationContext.setAborted(true);
                    }
                    observation.stop();
                }).contextWrite(context -> context.put((Object)"micrometer.observation", (Object)observation));
            });
        }

        private ClientRequest.Builder initRequestBuilder() {
            if (DefaultWebClient.this.defaultRequest != null) {
                DefaultWebClient.this.defaultRequest.accept(this);
            }
            ClientRequest.Builder builder = ClientRequest.create(this.httpMethod, this.initUri()).headers(this::initHeaders).cookies(this::initCookies).attributes((Map<String, Object> attributes) -> attributes.putAll(this.attributes));
            if (this.httpRequestConsumer != null) {
                builder.httpRequest(this.httpRequestConsumer);
            }
            if (this.inserter != null) {
                builder.body(this.inserter);
            }
            return builder;
        }

        private URI initUri() {
            return this.uri != null ? this.uri : DefaultWebClient.this.uriBuilderFactory.expand("", new Object[0]);
        }

        private void initHeaders(HttpHeaders out) {
            if (!CollectionUtils.isEmpty((Map)DefaultWebClient.this.defaultHeaders)) {
                out.putAll((Map)DefaultWebClient.this.defaultHeaders);
            }
            if (!CollectionUtils.isEmpty((Map)this.headers)) {
                out.putAll((Map)this.headers);
            }
        }

        private void initCookies(MultiValueMap<String, String> out) {
            if (!CollectionUtils.isEmpty(DefaultWebClient.this.defaultCookies)) {
                out.putAll(DefaultWebClient.this.defaultCookies);
            }
            if (!CollectionUtils.isEmpty(this.cookies)) {
                out.putAll(this.cookies);
            }
        }
    }

    private static class DefaultResponseSpec
    implements WebClient.ResponseSpec {
        private static final StatusHandler DEFAULT_STATUS_HANDLER = new StatusHandler(code -> code.value() >= 400, ClientResponse::createException);
        private final HttpMethod httpMethod;
        private final URI uri;
        private final Mono<ClientResponse> responseMono;
        private final List<StatusHandler> statusHandlers = new ArrayList<StatusHandler>(1);
        private final int defaultStatusHandlerCount;

        DefaultResponseSpec(HttpMethod httpMethod, URI uri, Mono<ClientResponse> responseMono, List<StatusHandler> defaultStatusHandlers) {
            this.httpMethod = httpMethod;
            this.uri = uri;
            this.responseMono = responseMono;
            this.statusHandlers.addAll(defaultStatusHandlers);
            this.statusHandlers.add(DEFAULT_STATUS_HANDLER);
            this.defaultStatusHandlerCount = this.statusHandlers.size();
        }

        @Override
        public WebClient.ResponseSpec onStatus(Predicate<HttpStatusCode> statusCodePredicate, Function<ClientResponse, Mono<? extends Throwable>> exceptionFunction) {
            Assert.notNull(statusCodePredicate, (String)"StatusCodePredicate must not be null");
            Assert.notNull(exceptionFunction, (String)"Function must not be null");
            int index = this.statusHandlers.size() - this.defaultStatusHandlerCount;
            this.statusHandlers.add(index, new StatusHandler(statusCodePredicate, exceptionFunction));
            return this;
        }

        @Override
        public WebClient.ResponseSpec onRawStatus(IntPredicate statusCodePredicate, Function<ClientResponse, Mono<? extends Throwable>> exceptionFunction) {
            return this.onStatus(DefaultResponseSpec.toStatusCodePredicate(statusCodePredicate), exceptionFunction);
        }

        private static Predicate<HttpStatusCode> toStatusCodePredicate(IntPredicate predicate) {
            return value -> predicate.test(value.value());
        }

        @Override
        public <T> Mono<T> bodyToMono(Class<T> elementClass) {
            Assert.notNull(elementClass, (String)"Class must not be null");
            return this.responseMono.flatMap(response -> this.handleBodyMono((ClientResponse)response, response.bodyToMono(elementClass)));
        }

        @Override
        public <T> Mono<T> bodyToMono(ParameterizedTypeReference<T> elementTypeRef) {
            Assert.notNull(elementTypeRef, (String)"ParameterizedTypeReference must not be null");
            return this.responseMono.flatMap(response -> this.handleBodyMono((ClientResponse)response, response.bodyToMono(elementTypeRef)));
        }

        @Override
        public <T> Flux<T> bodyToFlux(Class<T> elementClass) {
            Assert.notNull(elementClass, (String)"Class must not be null");
            return this.responseMono.flatMapMany(response -> this.handleBodyFlux((ClientResponse)response, response.bodyToFlux(elementClass)));
        }

        @Override
        public <T> Flux<T> bodyToFlux(ParameterizedTypeReference<T> elementTypeRef) {
            Assert.notNull(elementTypeRef, (String)"ParameterizedTypeReference must not be null");
            return this.responseMono.flatMapMany(response -> this.handleBodyFlux((ClientResponse)response, response.bodyToFlux(elementTypeRef)));
        }

        @Override
        public <T> Mono<ResponseEntity<T>> toEntity(Class<T> bodyClass) {
            return this.responseMono.flatMap(response -> WebClientUtils.mapToEntity(response, this.handleBodyMono((ClientResponse)response, response.bodyToMono(bodyClass))));
        }

        @Override
        public <T> Mono<ResponseEntity<T>> toEntity(ParameterizedTypeReference<T> bodyTypeRef) {
            return this.responseMono.flatMap(response -> WebClientUtils.mapToEntity(response, this.handleBodyMono((ClientResponse)response, response.bodyToMono(bodyTypeRef))));
        }

        @Override
        public <T> Mono<ResponseEntity<List<T>>> toEntityList(Class<T> elementClass) {
            return this.responseMono.flatMap(response -> WebClientUtils.mapToEntityList(response, this.handleBodyFlux((ClientResponse)response, response.bodyToFlux(elementClass))));
        }

        @Override
        public <T> Mono<ResponseEntity<List<T>>> toEntityList(ParameterizedTypeReference<T> elementTypeRef) {
            return this.responseMono.flatMap(response -> WebClientUtils.mapToEntityList(response, this.handleBodyFlux((ClientResponse)response, response.bodyToFlux(elementTypeRef))));
        }

        @Override
        public <T> Mono<ResponseEntity<Flux<T>>> toEntityFlux(Class<T> elementType) {
            return this.responseMono.flatMap(response -> this.handlerEntityFlux((ClientResponse)response, response.bodyToFlux(elementType)));
        }

        @Override
        public <T> Mono<ResponseEntity<Flux<T>>> toEntityFlux(ParameterizedTypeReference<T> elementTypeRef) {
            return this.responseMono.flatMap(response -> this.handlerEntityFlux((ClientResponse)response, response.bodyToFlux(elementTypeRef)));
        }

        @Override
        public <T> Mono<ResponseEntity<Flux<T>>> toEntityFlux(BodyExtractor<Flux<T>, ? super ClientHttpResponse> bodyExtractor) {
            return this.responseMono.flatMap(response -> this.handlerEntityFlux((ClientResponse)response, (Flux)((Flux)response.body(bodyExtractor))));
        }

        @Override
        public Mono<ResponseEntity<Void>> toBodilessEntity() {
            return this.responseMono.flatMap(response -> WebClientUtils.mapToEntity(response, this.handleBodyMono((ClientResponse)response, (Mono)Mono.empty())).flatMap(entity -> response.releaseBody().onErrorResume(WebClientUtils.WRAP_EXCEPTION_PREDICATE, this.exceptionWrappingFunction((ClientResponse)response)).thenReturn(entity)));
        }

        private <T> Mono<T> handleBodyMono(ClientResponse response, Mono<T> body2) {
            body2 = body2.onErrorResume(WebClientUtils.WRAP_EXCEPTION_PREDICATE, this.exceptionWrappingFunction(response));
            Mono<T> result = this.applyStatusHandlers(response);
            return result != null ? result.switchIfEmpty(body2) : body2;
        }

        private <T> Publisher<T> handleBodyFlux(ClientResponse response, Flux<T> body2) {
            body2 = body2.onErrorResume(WebClientUtils.WRAP_EXCEPTION_PREDICATE, this.exceptionWrappingFunction(response));
            Mono<T> result = this.applyStatusHandlers(response);
            return result != null ? result.flux().switchIfEmpty((Publisher)body2) : body2;
        }

        private <T> Mono<? extends ResponseEntity<Flux<T>>> handlerEntityFlux(ClientResponse response, Flux<T> body2) {
            ResponseEntity entity = new ResponseEntity((Object)body2.onErrorResume(WebClientUtils.WRAP_EXCEPTION_PREDICATE, this.exceptionWrappingFunction(response)), (MultiValueMap)response.headers().asHttpHeaders(), response.statusCode());
            Mono<T> result = this.applyStatusHandlers(response);
            return result != null ? result.defaultIfEmpty((Object)entity) : Mono.just((Object)entity);
        }

        private <T> Function<Throwable, Mono<? extends T>> exceptionWrappingFunction(ClientResponse response) {
            return t -> response.createException().flatMap(ex -> Mono.error((Throwable)ex.initCause(t)));
        }

        @Nullable
        private <T> Mono<T> applyStatusHandlers(ClientResponse response) {
            HttpStatusCode statusCode = response.statusCode();
            for (StatusHandler handler : this.statusHandlers) {
                Mono exMono;
                if (!handler.test(statusCode)) continue;
                try {
                    exMono = handler.apply(response);
                    exMono = exMono.flatMap(ex -> DefaultWebClient.releaseIfNotConsumed(response, ex));
                    exMono = exMono.onErrorResume(ex -> DefaultWebClient.releaseIfNotConsumed(response, ex));
                }
                catch (Throwable ex2) {
                    exMono = DefaultWebClient.releaseIfNotConsumed(response, ex2);
                }
                Mono result = exMono.flatMap(Mono::error);
                return result.checkpoint(statusCode + " from " + this.httpMethod + " " + DefaultResponseSpec.getUriToLog(this.uri) + " [DefaultWebClient]");
            }
            return null;
        }

        private static URI getUriToLog(URI uri) {
            if (StringUtils.hasText((String)uri.getQuery())) {
                try {
                    uri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), null, null);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            return uri;
        }

        private static class StatusHandler {
            private final Predicate<HttpStatusCode> predicate;
            private final Function<ClientResponse, Mono<? extends Throwable>> exceptionFunction;

            public StatusHandler(Predicate<HttpStatusCode> predicate, Function<ClientResponse, Mono<? extends Throwable>> exceptionFunction) {
                this.predicate = predicate;
                this.exceptionFunction = exceptionFunction;
            }

            public boolean test(HttpStatusCode status) {
                return this.predicate.test(status);
            }

            public Mono<? extends Throwable> apply(ClientResponse response) {
                return this.exceptionFunction.apply(response);
            }
        }
    }

    private static class ObservationFilterFunction
    implements ExchangeFilterFunction {
        private final ClientRequestObservationContext observationContext;

        ObservationFilterFunction(ClientRequestObservationContext observationContext) {
            this.observationContext = observationContext;
        }

        @Override
        public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
            return next.exchange(request).doOnNext(arg_0 -> ((ClientRequestObservationContext)this.observationContext).setResponse(arg_0));
        }
    }
}

