/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindException;
import org.springframework.validation.method.MethodValidationException;
import org.springframework.web.ErrorResponse;
import org.springframework.web.ErrorResponseException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;
import org.springframework.web.method.annotation.HandlerMethodValidationException;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.resource.NoResourceFoundException;

public abstract class ResponseEntityExceptionHandler
implements MessageSourceAware {
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.servlet.PageNotFound";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Nullable
    private MessageSource messageSource;

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Nullable
    protected MessageSource getMessageSource() {
        return this.messageSource;
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class, HttpMediaTypeNotSupportedException.class, HttpMediaTypeNotAcceptableException.class, MissingPathVariableException.class, MissingServletRequestParameterException.class, MissingServletRequestPartException.class, ServletRequestBindingException.class, MethodArgumentNotValidException.class, HandlerMethodValidationException.class, NoHandlerFoundException.class, NoResourceFoundException.class, AsyncRequestTimeoutException.class, ErrorResponseException.class, MaxUploadSizeExceededException.class, ConversionNotSupportedException.class, TypeMismatchException.class, HttpMessageNotReadableException.class, HttpMessageNotWritableException.class, MethodValidationException.class, BindException.class})
    @Nullable
    public final ResponseEntity<Object> handleException(Exception ex, WebRequest request) throws Exception {
        if (ex instanceof HttpRequestMethodNotSupportedException) {
            HttpRequestMethodNotSupportedException subEx = (HttpRequestMethodNotSupportedException)ex;
            return this.handleHttpRequestMethodNotSupported(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
        }
        if (ex instanceof HttpMediaTypeNotSupportedException) {
            HttpMediaTypeNotSupportedException subEx = (HttpMediaTypeNotSupportedException)ex;
            return this.handleHttpMediaTypeNotSupported(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
        }
        if (ex instanceof HttpMediaTypeNotAcceptableException) {
            HttpMediaTypeNotAcceptableException subEx = (HttpMediaTypeNotAcceptableException)((Object)ex);
            return this.handleHttpMediaTypeNotAcceptable(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
        }
        if (ex instanceof MissingPathVariableException) {
            MissingPathVariableException subEx = (MissingPathVariableException)ex;
            return this.handleMissingPathVariable(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
        }
        if (ex instanceof MissingServletRequestParameterException) {
            MissingServletRequestParameterException subEx = (MissingServletRequestParameterException)ex;
            return this.handleMissingServletRequestParameter(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
        }
        if (ex instanceof MissingServletRequestPartException) {
            MissingServletRequestPartException subEx = (MissingServletRequestPartException)ex;
            return this.handleMissingServletRequestPart(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
        }
        if (ex instanceof ServletRequestBindingException) {
            ServletRequestBindingException subEx = (ServletRequestBindingException)ex;
            return this.handleServletRequestBindingException(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
        }
        if (ex instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException subEx = (MethodArgumentNotValidException)ex;
            return this.handleMethodArgumentNotValid(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
        }
        if (ex instanceof HandlerMethodValidationException) {
            HandlerMethodValidationException subEx = (HandlerMethodValidationException)ex;
            return this.handleHandlerMethodValidationException(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
        }
        if (ex instanceof NoHandlerFoundException) {
            NoHandlerFoundException subEx = (NoHandlerFoundException)((Object)ex);
            return this.handleNoHandlerFoundException(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
        }
        if (ex instanceof NoResourceFoundException) {
            NoResourceFoundException subEx = (NoResourceFoundException)((Object)ex);
            return this.handleNoResourceFoundException(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
        }
        if (ex instanceof AsyncRequestTimeoutException) {
            AsyncRequestTimeoutException subEx = (AsyncRequestTimeoutException)ex;
            return this.handleAsyncRequestTimeoutException(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
        }
        if (ex instanceof ErrorResponseException) {
            ErrorResponseException subEx = (ErrorResponseException)ex;
            return this.handleErrorResponseException(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
        }
        if (ex instanceof MaxUploadSizeExceededException) {
            MaxUploadSizeExceededException subEx = (MaxUploadSizeExceededException)ex;
            return this.handleMaxUploadSizeExceededException(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
        }
        HttpHeaders headers = new HttpHeaders();
        if (ex instanceof ConversionNotSupportedException) {
            ConversionNotSupportedException theEx = (ConversionNotSupportedException)ex;
            return this.handleConversionNotSupported(theEx, headers, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, request);
        }
        if (ex instanceof TypeMismatchException) {
            TypeMismatchException theEx = (TypeMismatchException)ex;
            return this.handleTypeMismatch(theEx, headers, (HttpStatusCode)HttpStatus.BAD_REQUEST, request);
        }
        if (ex instanceof HttpMessageNotReadableException) {
            HttpMessageNotReadableException theEx = (HttpMessageNotReadableException)ex;
            return this.handleHttpMessageNotReadable(theEx, headers, (HttpStatusCode)HttpStatus.BAD_REQUEST, request);
        }
        if (ex instanceof HttpMessageNotWritableException) {
            HttpMessageNotWritableException theEx = (HttpMessageNotWritableException)ex;
            return this.handleHttpMessageNotWritable(theEx, headers, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, request);
        }
        if (ex instanceof MethodValidationException) {
            MethodValidationException subEx = (MethodValidationException)ex;
            return this.handleMethodValidationException(subEx, headers, HttpStatus.INTERNAL_SERVER_ERROR, request);
        }
        throw ex;
    }

    @Nullable
    protected ResponseEntity<Object> handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        pageNotFoundLogger.warn((Object)ex.getMessage());
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleHttpMediaTypeNotSupported(HttpMediaTypeNotSupportedException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleHttpMediaTypeNotAcceptable(HttpMediaTypeNotAcceptableException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)((Object)ex), null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleMissingPathVariable(MissingPathVariableException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleMissingServletRequestPart(MissingServletRequestPartException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleServletRequestBindingException(ServletRequestBindingException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleHandlerMethodValidationException(HandlerMethodValidationException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleNoHandlerFoundException(NoHandlerFoundException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)((Object)ex), null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleNoResourceFoundException(NoResourceFoundException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)((Object)ex), null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleAsyncRequestTimeoutException(AsyncRequestTimeoutException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleErrorResponseException(ErrorResponseException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleMaxUploadSizeExceededException(MaxUploadSizeExceededException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleConversionNotSupported(ConversionNotSupportedException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        Object[] args = new Object[]{ex.getPropertyName(), ex.getValue()};
        String defaultDetail = "Failed to convert '" + args[0] + "' with value: '" + args[1] + "'";
        ProblemDetail body2 = this.createProblemDetail((Exception)ex, status, defaultDetail, null, args, request);
        return this.handleExceptionInternal((Exception)ex, body2, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleTypeMismatch(TypeMismatchException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        Object[] args = new Object[]{ex.getPropertyName(), ex.getValue()};
        String defaultDetail = "Failed to convert '" + args[0] + "' with value: '" + args[1] + "'";
        String messageCode = ErrorResponse.getDefaultDetailMessageCode(TypeMismatchException.class, null);
        ProblemDetail body2 = this.createProblemDetail((Exception)ex, status, defaultDetail, messageCode, args, request);
        return this.handleExceptionInternal((Exception)ex, body2, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        ProblemDetail body2 = this.createProblemDetail((Exception)ex, status, "Failed to read request", null, null, request);
        return this.handleExceptionInternal((Exception)ex, body2, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleHttpMessageNotWritable(HttpMessageNotWritableException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        ProblemDetail body2 = this.createProblemDetail((Exception)ex, status, "Failed to write request", null, null, request);
        return this.handleExceptionInternal((Exception)ex, body2, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleMethodValidationException(MethodValidationException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        ProblemDetail body2 = this.createProblemDetail((Exception)ex, (HttpStatusCode)status, "Validation failed", null, null, request);
        return this.handleExceptionInternal((Exception)ex, body2, headers, (HttpStatusCode)status, request);
    }

    protected ProblemDetail createProblemDetail(Exception ex, HttpStatusCode status, String defaultDetail, @Nullable String detailMessageCode, @Nullable Object[] detailMessageArguments, WebRequest request) {
        ErrorResponse.Builder builder = ErrorResponse.builder((Throwable)ex, (HttpStatusCode)status, (String)defaultDetail);
        if (detailMessageCode != null) {
            builder.detailMessageCode(detailMessageCode);
        }
        if (detailMessageArguments != null) {
            builder.detailMessageArguments(detailMessageArguments);
        }
        return builder.build().updateAndGetBody(this.messageSource, LocaleContextHolder.getLocale());
    }

    @Nullable
    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, @Nullable Object body2, HttpHeaders headers, HttpStatusCode statusCode, WebRequest request) {
        ServletWebRequest servletWebRequest;
        HttpServletResponse response;
        if (request instanceof ServletWebRequest && (response = (servletWebRequest = (ServletWebRequest)request).getResponse()) != null && response.isCommitted()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Response already committed. Ignoring: " + ex));
            }
            return null;
        }
        if (body2 == null && ex instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)ex;
            body2 = errorResponse.updateAndGetBody(this.messageSource, LocaleContextHolder.getLocale());
        }
        if (statusCode.equals(HttpStatus.INTERNAL_SERVER_ERROR) && body2 == null) {
            request.setAttribute("jakarta.servlet.error.exception", (Object)ex, 0);
        }
        return this.createResponseEntity(body2, headers, statusCode, request);
    }

    protected ResponseEntity<Object> createResponseEntity(@Nullable Object body2, HttpHeaders headers, HttpStatusCode statusCode, WebRequest request) {
        return new ResponseEntity(body2, (MultiValueMap)headers, statusCode);
    }
}

