/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.standard;

import jakarta.websocket.server.ServerEndpointConfig;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class SpringConfigurator
extends ServerEndpointConfig.Configurator {
    private static final String NO_VALUE = ObjectUtils.identityToString((Object)new Object());
    private static final Log logger = LogFactory.getLog(SpringConfigurator.class);
    private static final Map<String, Map<Class<?>, String>> cache = new ConcurrentHashMap();

    public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
        WebApplicationContext wac = ContextLoader.getCurrentWebApplicationContext();
        if (wac == null) {
            String message = "Failed to find the root WebApplicationContext. Was ContextLoaderListener not used?";
            logger.error((Object)message);
            throw new IllegalStateException(message);
        }
        String beanName = ClassUtils.getShortNameAsProperty(endpointClass);
        if (wac.containsBean(beanName)) {
            Object endpoint = wac.getBean(beanName, endpointClass);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Using @ServerEndpoint singleton " + String.valueOf(endpoint)));
            }
            return (T)endpoint;
        }
        Component ann = (Component)AnnotationUtils.findAnnotation(endpointClass, Component.class);
        if (ann != null && wac.containsBean(ann.value())) {
            Object endpoint = wac.getBean(ann.value(), endpointClass);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Using @ServerEndpoint singleton " + String.valueOf(endpoint)));
            }
            return (T)endpoint;
        }
        beanName = this.getBeanNameByType(wac, endpointClass);
        if (beanName != null) {
            return (T)wac.getBean(beanName);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Creating new @ServerEndpoint instance of type " + String.valueOf(endpointClass)));
        }
        return (T)wac.getAutowireCapableBeanFactory().createBean(endpointClass);
    }

    @Nullable
    private String getBeanNameByType(WebApplicationContext wac, Class<?> endpointClass) {
        String wacId = wac.getId();
        Map beanNamesByType = cache.computeIfAbsent(wacId, key -> new ConcurrentHashMap());
        String beanName = (String)beanNamesByType.get(endpointClass);
        if (beanName == null) {
            Object[] names = wac.getBeanNamesForType(endpointClass);
            beanName = names.length == 1 ? names[0] : NO_VALUE;
            beanNamesByType.put(endpointClass, beanName);
            if (names.length > 1) {
                throw new IllegalStateException("Found multiple @ServerEndpoint's of type [" + endpointClass.getName() + "]: bean names " + Arrays.toString(names));
            }
        }
        return NO_VALUE.equals(beanName) ? null : beanName;
    }
}

