/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.autoproxy;

import org.springframework.aop.Advisor;
import org.springframework.aop.aspectj.AspectJAopUtils;
import org.springframework.aop.aspectj.AspectJPrecedenceInformation;
import org.springframework.core.OrderComparator;

class AspectJPrecedenceAwareOrderComparator
extends OrderComparator {
    private static final int HIGHER_PRECEDENCE = -1;
    private static final int SAME_PRECEDENCE = 0;
    private static final int LOWER_PRECEDENCE = 1;
    private static final int NOT_COMPARABLE = 0;

    AspectJPrecedenceAwareOrderComparator() {
    }

    public int compare(Object o1, Object o2) {
        if (!this.isAdvisor(o1) || !this.isAdvisor(o2)) {
            throw new IllegalArgumentException("AspectJPrecedenceAwareOrderComparator can only compare the order of Advisors,but was passed a " + (o1 != null ? o1.getClass().getName() : "null object") + "and a " + (o1 != null ? o1.getClass().getName() : "null object") + ".");
        }
        int ret = 0;
        Advisor advisor1 = (Advisor)o1;
        Advisor advisor2 = (Advisor)o2;
        boolean oneOrOtherIsAfterAdvice = AspectJAopUtils.isAfterAdvice(advisor1) || AspectJAopUtils.isAfterAdvice(advisor2);
        boolean oneOrOtherIsBeforeAdvice = AspectJAopUtils.isBeforeAdvice(advisor1) || AspectJAopUtils.isBeforeAdvice(advisor2);
        ret = oneOrOtherIsAfterAdvice && oneOrOtherIsBeforeAdvice ? 0 : this.getAdvisorPrecedence(advisor1, advisor2);
        return ret;
    }

    private boolean isAdvisor(Object obj) {
        return obj != null && obj instanceof Advisor;
    }

    private int getAdvisorPrecedence(Advisor advisor1, Advisor advisor2) {
        int advisorPrecedence = super.compare(advisor1, advisor2);
        if (this.haveSamePrecedence(advisorPrecedence) && this.declaredInSameAspect(advisor1, advisor2)) {
            advisorPrecedence = this.comparePrecedenceWithinAspect(advisor1, advisor2);
        }
        return advisorPrecedence;
    }

    private int comparePrecedenceWithinAspect(Advisor advisor1, Advisor advisor2) {
        boolean oneOrOtherIsAfterAdvice = AspectJAopUtils.isAfterAdvice(advisor1) || AspectJAopUtils.isAfterAdvice(advisor2);
        int adviceDeclarationOrderDelta = this.getAspectDeclarationOrder(advisor1) - this.getAspectDeclarationOrder(advisor2);
        if (oneOrOtherIsAfterAdvice) {
            if (adviceDeclarationOrderDelta < 0) {
                return 1;
            }
            if (adviceDeclarationOrderDelta == 0) {
                return 0;
            }
            return -1;
        }
        if (adviceDeclarationOrderDelta < 0) {
            return -1;
        }
        if (adviceDeclarationOrderDelta == 0) {
            return 0;
        }
        return 1;
    }

    private boolean declaredInSameAspect(Advisor advisor1, Advisor advisor2) {
        if (!this.hasAspectName(advisor1) || !this.hasAspectName(advisor2)) {
            return false;
        }
        return this.getAspectName(advisor1).equals(this.getAspectName(advisor2));
    }

    private boolean hasAspectName(Advisor anAdvisor) {
        if (anAdvisor instanceof AspectJPrecedenceInformation) {
            return true;
        }
        return anAdvisor.getAdvice() instanceof AspectJPrecedenceInformation;
    }

    private String getAspectName(Advisor anAdvisor) {
        return AspectJAopUtils.getAspectJPrecedenceInformationFor(anAdvisor).getAspectName();
    }

    private int getAspectDeclarationOrder(Advisor anAdvisor) {
        AspectJPrecedenceInformation precedenceInfo = AspectJAopUtils.getAspectJPrecedenceInformationFor(anAdvisor);
        if (precedenceInfo != null) {
            return precedenceInfo.getDeclarationOrder();
        }
        return 0;
    }

    private boolean haveSamePrecedence(int advisorPrecedence) {
        return advisorPrecedence == 0;
    }
}

