/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public abstract class BridgeMethodResolver {
    static /* synthetic */ Class class$java$lang$Object;

    public static Method findBridgedMethod(Method bridgeMethod) {
        Assert.notNull(bridgeMethod, "Method must not be null");
        if (!bridgeMethod.isBridge()) {
            return bridgeMethod;
        }
        ArrayList<Method> candidateMethods = new ArrayList<Method>();
        Method[] methods = ReflectionUtils.getAllDeclaredMethods(bridgeMethod.getDeclaringClass());
        for (int i = 0; i < methods.length; ++i) {
            Method candidateMethod = methods[i];
            if (!BridgeMethodResolver.isBridgedCandidateFor(candidateMethod, bridgeMethod)) continue;
            candidateMethods.add(candidateMethod);
        }
        if (candidateMethods.isEmpty()) {
            throw new IllegalStateException("Unable to locate bridged method for bridge method '" + bridgeMethod + "'");
        }
        if (candidateMethods.size() == 1) {
            return (Method)candidateMethods.get(0);
        }
        return BridgeMethodResolver.searchCandidates(candidateMethods, bridgeMethod);
    }

    private static Method searchCandidates(List candidateMethods, Method bridgeMethod) {
        Map typeParameterMap = BridgeMethodResolver.createTypeVariableMap(bridgeMethod.getDeclaringClass());
        for (int i = 0; i < candidateMethods.size(); ++i) {
            Method candidateMethod = (Method)candidateMethods.get(i);
            if (!BridgeMethodResolver.isBridgeMethodFor(bridgeMethod, candidateMethod, typeParameterMap)) continue;
            return candidateMethod;
        }
        return null;
    }

    private static boolean isBridgedCandidateFor(Method candidateMethod, Method bridgeMethod) {
        return !candidateMethod.isBridge() && !candidateMethod.equals(bridgeMethod) && candidateMethod.getName().equals(bridgeMethod.getName()) && candidateMethod.getParameterTypes().length == bridgeMethod.getParameterTypes().length;
    }

    static boolean isBridgeMethodFor(Method bridgeMethod, Method candidateMethod, Map typeVariableMap) {
        Method method = BridgeMethodResolver.findGenericDeclaration(bridgeMethod);
        return method != null ? BridgeMethodResolver.isResolvedTypeMatch(method, candidateMethod, typeVariableMap) : false;
    }

    private static Method findGenericDeclaration(Method bridgeMethod) {
        for (Class<?> superclass = bridgeMethod.getDeclaringClass().getSuperclass(); superclass != (class$java$lang$Object == null ? BridgeMethodResolver.class$("java.lang.Object") : class$java$lang$Object); superclass = superclass.getSuperclass()) {
            Method m = BridgeMethodResolver.searchForMatch(superclass, bridgeMethod);
            if (m == null) continue;
            return m;
        }
        Class<?>[] interfaces = bridgeMethod.getDeclaringClass().getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            Method m = BridgeMethodResolver.searchForMatch(anInterface, bridgeMethod);
            if (m == null) continue;
            return m;
        }
        throw new IllegalStateException("Unable to locate generic definition for bridge method '" + bridgeMethod + "'");
    }

    private static boolean isResolvedTypeMatch(Method genericMethod, Method candidateMethod, Map typeVariableMap) {
        Type[] genericParameters = genericMethod.getGenericParameterTypes();
        Object[] resolvedTypes = new Class[genericParameters.length];
        for (int i = 0; i < genericParameters.length; ++i) {
            Type genericParameter = genericParameters[i];
            if (genericParameter instanceof TypeVariable) {
                TypeVariable tv = (TypeVariable)genericParameter;
                resolvedTypes[i] = (Class)typeVariableMap.get(tv.getName());
                continue;
            }
            resolvedTypes[i] = (Class)genericParameter;
        }
        return Arrays.equals(resolvedTypes, candidateMethod.getParameterTypes());
    }

    private static Method searchForMatch(Class type, Method bridgeMethod) {
        try {
            return type.getDeclaredMethod(bridgeMethod.getName(), bridgeMethod.getParameterTypes());
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    static Map createTypeVariableMap(Class cls) {
        Class<Object> type;
        HashMap typeVariableMap = new HashMap();
        Type genericType = cls.getGenericSuperclass();
        for (type = cls.getSuperclass(); type != (class$java$lang$Object == null ? BridgeMethodResolver.class$("java.lang.Object") : class$java$lang$Object); type = type.getSuperclass()) {
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt1 = (ParameterizedType)genericType;
                BridgeMethodResolver.populateTypeMapFromParameterizedType(typeVariableMap, pt1);
            }
            genericType = type.getGenericSuperclass();
        }
        type = cls;
        while (type.isMemberClass()) {
            genericType = type.getGenericSuperclass();
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                BridgeMethodResolver.populateTypeMapFromParameterizedType(typeVariableMap, pt);
            }
            type = type.getEnclosingClass();
        }
        Type[] genericInterfaces = cls.getGenericInterfaces();
        for (int i = 0; i < genericInterfaces.length; ++i) {
            Type genericInterface = genericInterfaces[i];
            if (!(genericInterface instanceof ParameterizedType)) continue;
            ParameterizedType pt = (ParameterizedType)genericInterface;
            BridgeMethodResolver.populateTypeMapFromParameterizedType(typeVariableMap, pt);
        }
        return typeVariableMap;
    }

    private static void populateTypeMapFromParameterizedType(Map typeVariableMap, ParameterizedType type) {
        Type[] actualTypeArguments = type.getActualTypeArguments();
        TypeVariable<Class<T>>[] typeVariables = ((Class)type.getRawType()).getTypeParameters();
        for (int i = 0; i < actualTypeArguments.length; ++i) {
            Type actualTypeArgument = actualTypeArguments[i];
            if (!(actualTypeArgument instanceof Class)) continue;
            typeVariableMap.put(typeVariables[i].getName(), (Class)actualTypeArgument);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

