/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;
import org.springframework.core.ParameterNameDiscoverer;

public class LocalVariableTableParameterNameDiscover
implements ParameterNameDiscoverer {
    private final Log logger = LogFactory.getLog(this.getClass());

    public String[] getParameterNames(Method method) {
        ParameterNameDiscoveringVisitor visitor = null;
        try {
            visitor = this.visitMethod(method);
            if (visitor.foundTargetMember()) {
                return visitor.getParameterNames();
            }
            return null;
        }
        catch (IOException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("IOException whilst attempting to read .class file for class [" + method.getDeclaringClass().getName() + "] - unable to determine parameter names for method " + method.getName()), (Throwable)ex);
            }
            return null;
        }
    }

    public String[] getParameterNames(Constructor ctor) {
        ParameterNameDiscoveringVisitor visitor = null;
        try {
            visitor = this.visitConstructor(ctor);
            if (visitor.foundTargetMember()) {
                return visitor.getParameterNames();
            }
            return null;
        }
        catch (IOException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("IOException whilst attempting to read .class file for class [" + ctor.getDeclaringClass().getName() + "] - unable to determine parameter names for constructor"), (Throwable)ex);
            }
            return null;
        }
    }

    private ParameterNameDiscoveringVisitor visitMethod(Method method) throws IOException {
        ClassReader reader = new ClassReader(method.getDeclaringClass().getName());
        FindMethodParamNamesClassVisitor classVisitor = new FindMethodParamNamesClassVisitor(method);
        reader.accept((ClassVisitor)classVisitor, false);
        return classVisitor;
    }

    private ParameterNameDiscoveringVisitor visitConstructor(Constructor ctor) throws IOException {
        ClassReader reader = new ClassReader(ctor.getDeclaringClass().getName());
        FindConstructorParamNamesClassVisitor classVisitor = new FindConstructorParamNamesClassVisitor(ctor);
        reader.accept((ClassVisitor)classVisitor, false);
        return classVisitor;
    }

    private static class LocalVariableTableVisitor
    extends EmptyVisitor {
        private ParameterNameDiscoveringVisitor memberVisitor;
        private int numParameters;
        private String[] parameterNames;
        private boolean hasLVTInfo = false;

        public LocalVariableTableVisitor(ParameterNameDiscoveringVisitor memberVisitor, int numParams) {
            this.numParameters = numParams;
            this.parameterNames = new String[this.numParameters];
            this.memberVisitor = memberVisitor;
        }

        public void visitLocalVariable(String name, String description, String signature, Label start, Label end, int index) {
            this.hasLVTInfo = true;
            if (index > 0 && index <= this.numParameters) {
                this.parameterNames[index - 1] = name;
            }
        }

        public void visitEnd() {
            if (this.hasLVTInfo) {
                this.memberVisitor.setParameterNames(this.parameterNames);
            }
        }
    }

    private static class FindConstructorParamNamesClassVisitor
    extends ParameterNameDiscoveringVisitor {
        public FindConstructorParamNamesClassVisitor(Constructor cons) {
            super("<init>", cons.getParameterTypes().length);
            Type[] pTypes = new Type[cons.getParameterTypes().length];
            for (int i = 0; i < pTypes.length; ++i) {
                pTypes[i] = Type.getType(cons.getParameterTypes()[i]);
            }
            this.setDescriptorToMatch(Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])pTypes));
        }
    }

    private static class FindMethodParamNamesClassVisitor
    extends ParameterNameDiscoveringVisitor {
        public FindMethodParamNamesClassVisitor(Method method) {
            super(method.getName(), method.getParameterTypes().length);
            this.setDescriptorToMatch(Type.getMethodDescriptor((Method)method));
        }
    }

    private static abstract class ParameterNameDiscoveringVisitor
    extends EmptyVisitor {
        private String methodNameToMatch;
        private String descriptorToMatch;
        private int numParamsExpected;
        private boolean foundTargetMember = false;
        private String[] parameterNames;

        public ParameterNameDiscoveringVisitor(String name, int numParams) {
            this.methodNameToMatch = name;
            this.numParamsExpected = numParams;
        }

        public void setDescriptorToMatch(String descriptor) {
            this.descriptorToMatch = descriptor;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (name.equals(this.methodNameToMatch) && desc.equals(this.descriptorToMatch)) {
                this.foundTargetMember = true;
                return new LocalVariableTableVisitor(this, this.numParamsExpected);
            }
            return null;
        }

        public boolean foundTargetMember() {
            return this.foundTargetMember;
        }

        public String[] getParameterNames() {
            if (!this.foundTargetMember()) {
                throw new IllegalStateException("Can't ask for parameter names when target member has not been found");
            }
            return this.parameterNames;
        }

        public void setParameterNames(String[] names) {
            this.parameterNames = names;
        }
    }
}

